<?php
/*
* date last modified 28-11-2017
* Edited by PI-Digi Logical Solutions
* HTML Files - add_user.html.php
* Mysql Tables - tbl_technician, tbl_helper, tbl_vehicle, tbl_daily_stock
*/
include('includes/functions.php'); # general functions
include('includes/push_functions.php'); 


$isEdit = FALSE;
$latitude = $longitude = '';
$curDate = date('Y-m-d H:i:s');		
$showIncentive = FALSE;
$cashInHand = 0;
$soldCountAuto = 0;
$noReturn = $redReturn = $blueReturn = $errorReturn = 0;


$driverRs = mysqli_query($con, "SELECT id, name FROM tbl_technician WHERE status = 'Active' AND availability = 'on'");
$vehicleRs = mysqli_query($con, "SELECT id, number FROM tbl_vehicle WHERE status = 'Active'");
$helperRs = mysqli_query($con, "SELECT id, name FROM tbl_helper WHERE status = 'Active'");

//check if closed


if(isset($_REQUEST['id']) && $_REQUEST['id']!=''){
	
	$isEdit = TRUE;
	$stockId = mysqli_real_escape_string($con, trim($_REQUEST['id']));
	$pendingOrderCount = 0;
				
	$stockRs = mysqli_query($con, "SELECT * FROM tbl_daily_stock WHERE id = '".$stockId."'");
	if(mysqli_num_rows($stockRs)>0){
		$stockRec = mysqli_fetch_array($stockRs);
		
		$driverId = $stockRec['driver_id'];
		$driverName = getDriverName($driverId);
		
		$vehicleId = $stockRec['vehicle_id'];
		$vehicleNumber = getVehicleNumber($vehicleId);
		
		$helperId = $stockRec['helper_id'];
		$helperName = getHelperName($helperId);
		
		
		//check if any pending orders in this shift
		$pendingOrderRs = mysqli_query($con, "SELECT count(id) AS count FROM tbl_job WHERE technician_id = '".$driverId."' AND (status = 'assigned' OR status = 'start_off' OR status = 'arrived' OR status = 'completed')");
		if(mysqli_num_rows($pendingOrderRs)>0){
			$pendingOrderRec = mysqli_fetch_array($pendingOrderRs);
			$pendingOrderCount = $pendingOrderRec['count'];
		}
		
		$dateArr = explode('-',$stockRec['date']);
		$date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
		$openingTime = getFormattedTime($stockRec['opening_time']);
		$closingTime = getFormattedTime($stockRec['closing_time']);
		
		$openingStockRec = mysqli_fetch_array(mysqli_query($con, "SELECT SUM(opening_stock) AS opening_stock FROM tbl_daily_stock_products WHERE daily_stock_id = '".$stockId."'"));
		$openingStock = $openingStockRec['opening_stock'];		
			
		$totIncentivesAdded = $stockRec['tot_incentives'];
		$driverIncentive = $totIncentivesAdded/2;
		
		//find sold count from tbl_job
		$orderArray = array();
		$orderString = '';
		$soldRs = mysqli_query($con, "SELECT id, quantity, sale_type FROM tbl_job WHERE daily_stock_id = '".$stockId."'");
		if(mysqli_num_rows($soldRs)>0){
			while($soldRec = mysqli_fetch_array($soldRs)){
				$orderArray[] = $soldRec['id'];
				$saleType = $soldRec['sale_type'];
				$quantity = $soldRec['quantity'];
				if($saleType=='no_return'){
					$noReturn += $quantity;
				} else if($saleType=='red_return'){
					$redReturn += $quantity;
				} else if($saleType=='blue_return'){
					$blueReturn += $quantity;
				} else {
					$errorReturn += $quantity;
				}
				$soldCountAuto += $quantity;;
			}
			if(count($orderArray)>0){
				$orderString = implode(',', $orderArray);				
				$cashPaymentsRs = mysqli_query($con, "SELECT SUM(amount) AS amount FROM tbl_technician_payments WHERE job_id IN (".$orderString.") AND payment_method = 'Cash' AND status = 'paid'");
				if(mysqli_num_rows($cashPaymentsRs)>0){
					$cashPaymentsRec = mysqli_fetch_array($cashPaymentsRs);
					$cashInHand = $cashPaymentsRec['amount'];
					//get total wallet amount to be reduced in cash payments
					$walletPaymentsRs = mysqli_query($con, "SELECT SUM(wallet_amount) AS wallet_amount FROM tbl_technician_payments WHERE job_id IN (".$orderString.") AND payment_method = 'Cash' AND status = 'paid'");
					if(mysqli_num_rows($walletPaymentsRs)>0){
						$walletPaymentsRec = mysqli_fetch_array($walletPaymentsRs);
						$walletInCash = $walletPaymentsRec['wallet_amount'];
						$cashInHand = $cashInHand-$walletInCash;
					}
				}
			}
		}	
		
		if($stockRec['closed']=='no'){
			$closingStock = $openingStock-$soldCountAuto;
		} else {
			$closingStock = $stockRec['closing_stock'];
		}			
		
	} else {
		$error = 'The stock record does not exist!';
	}	
	
	if(isset($_POST['add'])) {	
			
		if(isset($_POST['closing_time']) && strlen($_POST['closing_time'])>0 && $_POST['closing_time']!='00:00') {		
			$closingTime = mysqli_real_escape_string($con, trim($_POST['closing_time']));
		} else {
			$error = 'Please select closing time';
		}
		
		$prodStockRs = mysqli_query($con, "SELECT * FROM tbl_daily_stock_products WHERE daily_stock_id = '".$stockId."'");
		if(mysqli_num_rows($prodStockRs)>0){
			while($prodStockRec = mysqli_fetch_array($prodStockRs)){
				$recId = $prodStockRec['id'];
				$pId = $prodStockRec['prod_id'];
				$prodOpeningStock = $prodStockRec['opening_stock'];
				if(isset($_POST['closing_stock'.$pId]) && strlen($_POST['closing_stock'.$pId])>0) {
					$closingStock = mysqli_real_escape_string($con, trim($_POST['closing_stock'.$pId]));
					if(is_numeric($closingStock)){
						if($closingStock>=0 && $closingStock<=$prodOpeningStock){
							$closingStocks[$recId] = $closingStock;
						} else {
							$error = 'The closing stock should be from 0 to '.$prodOpeningStock;
						}
					} else {
						$error = 'Enter numeric value for closing stocks';
					}
				} else {
					$error = 'Please enter closing stocks';
				}	
				
			} 
		}	
	
		/*if(isset($_POST['closing_stock']) && strlen($_POST['closing_stock'])>0) {
			$closingStock = mysqli_real_escape_string($con, trim($_POST['closing_stock']));
			if(is_numeric($closingStock)){
				if($closingStock>=0 && $closingStock<=$openingStock){
					//ok
				} else {
					$error = 'The closing stock should be from 0 to '.$openingStock;
				}
			} else {
				$error = 'Enter a numeric value for closing stock';
			}
		} else {
			$error = 'Please enter closing stock';
		}*/
		
	
	if(empty($error)) {
		
		//print_r($closingStocks); 
						
		//if(empty($error)) {
			
			$addedBy = $_SESSION['adminId'];
			
			//find incentives
			$soldCount = $openingStock-$closingStock;
			//get incentive
			$incentive = 0;
			$incentiveRate = 0;
			$incSettingsRs = mysqli_query($con, "SELECT * FROM tbl_incentive_settings ORDER BY min_sold_limit");
			if(mysqli_num_rows($incSettingsRs)>0){
				while($incSettingsRec = mysqli_fetch_array($incSettingsRs)){
					$minSoldCount = $incSettingsRec['min_sold_limit'];
					$incentiveRate = $incSettingsRec['amount'];
					if($soldCount>$minSoldCount){		
						$incentive = $soldCount*$incentiveRate;
					}
				}
			}
			if($incentive>0){
				$incentive = $incentive/2;
			}
			$driverIncentive = number_format((float)$incentive, 2, '.', '');
			//$driverIncentive = getIncentiveAmount($soldCount); //incentive for one person,ie, 1/2
			$totIncentives = 0;
			if($driverIncentive>0){
				$totIncentives = $driverIncentive*2;
			}
				
			$updateQry = "UPDATE tbl_daily_stock SET closing_time = '".$closingTime."', updated_by = '".$_SESSION['adminId']."', updated_on = '".$curDate."', closed = 'yes', tot_incentives = '".$totIncentives."'  WHERE id = '".$stockId."'";
			/*if($_SERVER['REMOTE_ADDR']='202.88.237.77'){
				echo $updateQry; exit;
			}*/	
			$execUpdate = mysqli_query($con,$updateQry);	
							
			if($execUpdate) {			
				
				foreach ($closingStocks as $recId => $closeStock) {
					//echo "UPDATE tbl_daily_stock_products SET closing_stock = '".$closeStock."' WHERE id = '".$recId."'";
					
					mysqli_query($con, "UPDATE tbl_daily_stock_products SET closing_stock = '".$closeStock."' WHERE id = '".$recId."'");
				}
				
				if($driverIncentive>0){
					//check if any recs added 
					$incChkRs = mysqli_query($con, "SELECT id FROM tbl_incentives WHERE daily_stock_id = '".$stockId."'");
					if(mysqli_num_rows($incChkRs)>0){
						mysqli_query($con, "UPDATE tbl_incentives SET driver_id = '".$driverId."', helper_id = '".$helperId."', amount = '".$driverIncentive."', sold_count = '".$soldCount."', rate = '".$incentiveRate."', date = '".$curDate."'  WHERE daily_stock_id = '".$stockId."'");
					} else {
						mysqli_query($con, "INSERT INTO tbl_incentives (daily_stock_id, driver_id, helper_id, amount, sold_count, rate, date) VALUES ('".$stockId."', '".$driverId."', '".$helperId."', '".$driverIncentive."', '".$soldCount."', '".$incentiveRate."', '".$curDate."')");
					}					
				}					
				
				//add cash from driver to tbl_admin_tech_incomes
				if($cashInHand>0){
					//check if already added. else create new
					$chkTechIncomeRs = mysqli_query($con, "SELECT id FROM tbl_admin_tech_incomes WHERE daily_stock_id = '".$stockId."'");
					if(mysqli_num_rows($chkTechIncomeRs)>0){
						mysqli_query($con, "UPDATE tbl_admin_tech_incomes SET amount = '".$cashInHand."', updated_on = '".$curDate."', updated_by = '".$_SESSION['adminId']."' WHERE id = '".$stockId."'");
					} else {
						$insertIncome = mysqli_query($con, "INSERT INTO tbl_admin_tech_incomes (daily_stock_id, technician_id, amount, date, added_by) VALUES ('".$stockId."', '".$driverId."', '".$cashInHand."', '".$curDate."', '".$_SESSION['adminId']."')");
						if($insertIncome){
							//ok
						} else {
							mail('renjith@pi-digi.com','AD LPG Admin Error','closing_stock.php income not added. Amount-'.$cashInHand.', stock id - '.$stockId);
						}
					}
					
				}		
				
				//check if the driver not yet closed any break. If so close that too
				$driverBreakRs = mysqli_query($con, "SELECT id FROM tbl_tech_availability_updates WHERE daily_stock_id = '".$stockId."' AND break_end = '0000-00-00 00:00:00' AND last_status = 'off'");
				if(mysqli_num_rows($driverBreakRs)>0){
					mysqli_query($con, "UPDATE tbl_tech_availability_updates SET break_end = '".$curDate."', last_status = 'on' WHERE daily_stock_id = '".$stockId."' AND break_end = '0000-00-00 00:00:00'");					
				}				
				$success = 'Closing Stock Updated Successfully';
										
			} else {
				$error = 'Unable to update details';
			}		
		//}		
	} 
}


	


} else {
	header('Location:index.php?page=manage_daily_stock');
	exit();	
}






?>