<?php
/*
* date last modified 03-10-2017
* Edited by PI-Digi Logical Solutions
* HTML Files - manage_staff.html.php
* Mysql Tables - tbl_admin, tbl_user, tbl_admin_type
*/
require_once('./classes/class.noseo_pagination.php'); # pagination class
require_once('./includes/functions.php'); # general functions

if(isset($_REQUEST['p']) && $_REQUEST['p']!=''){
	$p = trim($_REQUEST['p']);
} else {
	$p = 1;
}
$pageVars = '';
//$where = ' id > 0 ';
$where = ' ';
$orderBy = " ORDER BY id DESC ";


if(isset($_POST['clear'])) { ?>
<script language="javascript" type="text/javascript">			
	window.location='index.php?page=<?php echo $page;?>';
</script>
<?php }

$statRs = mysqli_query($con, "SELECT DISTINCT status FROM tbl_job WHERE is_project != 'yes'");
$productRs = mysqli_query($con, "SELECT id, name FROM tbl_products WHERE status = 'Active'");
$driverRs = mysqli_query($con, "SELECT id, name FROM tbl_technician WHERE status != 'Deleted' ORDER BY name");
$vehicleRs = mysqli_query($con, "SELECT id, number FROM tbl_vehicle WHERE status = 'Active'");
$cityRs = mysqli_query($con, "SELECT id, name FROM tbl_city WHERE status = 'Active'");

if(isset($_GET['action']) && $_GET['action'] == 'delete') {
	/* Delete User */
	if(isset($_GET['del_id']) && $_GET['del_id']!=''){
		//delete all extra tech requests
		mysqli_query($con, "DELETE FROM tbl_job_extra_tech WHERE job_id = '".$_GET['del_id']."' AND technician_id = '0'");		
		$delete = mysqli_query($con,'DELETE FROM tbl_job WHERE id='.$_GET['del_id']);
		if($delete) {
			$success = 'The order #'.$_GET['del_id'].' has been deleted';
			?>
	        <script language="javascript" type="text/javascript">			
				window.location='index.php?page=<?php echo $page;?>&success=<?php echo $success; ?>&p=<?php echo $p;?>';
			</script>
	        <?php
		}
	}
}

if(isset($_GET['action']) && $_GET['action'] == 'discard') {	
	if(isset($_GET['id']) && $_GET['id']!=''){
		$taskId = trim($_GET['id']);
		$update = mysqli_query($con,"UPDATE tbl_job SET status = 'discarded' WHERE id = '".$taskId."'");
		if($update) {
			//remove all payments of the task
			mysqli_query($con, "DELETE FROM tbl_technician_payments WHERE job_id = '".$taskId."'");
			$success = 'Discarded the job';
			?>
	        <script language="javascript" type="text/javascript">			
				window.location='index.php?page=<?php echo $page;?>&success=<?php echo $success; ?>&p=<?php echo $p;?>';
			</script>
	        <?php
		}
	}
}


$pageVars = '';

// Get All User details to list 
$prodwhere = ' id > 0 ';

if(isset($_REQUEST['task_status']) && strlen($_REQUEST['task_status'])>0) {
	$taskStatus = $_REQUEST['task_status'];
	if($taskStatus=='pending'){
		$where .= " AND status!='paid' ";		
	} else if($taskStatus=='Unassigned'){
		$where .= " AND status='New' AND now = 'yes' ";	
	} else if($taskStatus=='New'){
		$where .= " AND status='New' AND now != 'yes' ";	
	} else {
		$where .= " AND status='".$taskStatus."' ";		
	}
	$pageVars.= '&task_status='.$taskStatus.'&';
}

if(isset($_REQUEST['driver_id']) && $_REQUEST['driver_id']!='') {
	$taskTechId = trim($_REQUEST['driver_id']);
	$where .= " AND technician_id = '".$taskTechId."' ";
	$pageVars.= '&driver_id='.$taskTechId.'&';
}

if(isset($_REQUEST['status']) && $_REQUEST['status']=='closing') {	
	$where .= " AND (status='assigned' OR status='start_off' OR status='arrived' OR status='completed') ";
	$pageVars.= '&status=closing&';
}

if(isset($_REQUEST['vehicle_id']) && $_REQUEST['vehicle_id']!='') {
	$vehicleId = trim($_REQUEST['vehicle_id']);
	$where .= " AND daily_stock_id IN (SELECT id FROM tbl_daily_stock WHERE vehicle_id  = '".$vehicleId."') ";
	$pageVars.= '&vehicle_id='.$vehicleId.'&';
}
//SELECT * FROM tbl_job WHERE id > 0 AND (id IN (SELECT id FROM tbl_job WHERE address_id = '0' AND user_id IN(SELECT id FROM tbl_user WHERE city = '20')) OR id IN (SELECT id FROM tbl_job WHERE address_id IN(SELECT id FROM tbl_user_address WHERE city = '20'))) ORDER BY id DESC

if(isset($_REQUEST['city_id']) && $_REQUEST['city_id']!='') {
	$cityId = $_REQUEST['city_id'];	
	$city_ids = "";

	if (!is_array($cityId)) {
    	if($cityId!="") {
			$cityId_arr = explode(",", $cityId);
			$where .= " AND (id IN (SELECT id FROM tbl_job WHERE address_id  = '0' AND user_id IN(SELECT id FROM tbl_user WHERE city IN (".$cityId."))) OR id IN (SELECT id FROM tbl_job WHERE address_id  IN(SELECT id FROM tbl_user_address WHERE city IN (".$cityId.")))) ";
			$pageVars.= 'city_id='.$cityId.'&';
		}
	} else {
		foreach($cityId as $cid) {
			$city_ids .= $cid.',';
		}
		$cityId_arr = explode(",", $city_ids);
		if($city_ids!="") {
			$where .= " AND (id IN (SELECT id FROM tbl_job WHERE address_id  = '0' AND user_id IN(SELECT id FROM tbl_user WHERE city IN (".substr($city_ids,0,-1)."))) OR id IN (SELECT id FROM tbl_job WHERE address_id  IN(SELECT id FROM tbl_user_address WHERE city IN (".substr($city_ids,0,-1).")))) ";
			$pageVars.= 'city_id='.$city_ids.'&';
		}
	}
	
	
//	$where .= " AND (id IN (SELECT id FROM tbl_job WHERE address_id  = '0' AND user_id IN(SELECT id FROM tbl_user WHERE city = '".$cityId."')) OR id IN (SELECT id FROM tbl_job WHERE address_id  IN(SELECT id FROM tbl_user_address WHERE city = '".$cityId."'))) ";
//	$pageVars.= '&city_id='.$cityId.'&';
}

if(isset($_REQUEST['task_id']) && $_REQUEST['task_id']!='') {
	$taskId = trim($_REQUEST['task_id']);
	if(strpos($taskId, '#') !== false){
		$taskId = ltrim($taskId, '#');
	}
	$where .= " AND id = '".$taskId."' ";
	$pageVars.= '&task_id='.$taskId.'&';
}

if(isset($_REQUEST['stock_id']) && $_REQUEST['stock_id']!='') {
	$dailyStockId = trim($_REQUEST['stock_id']);
	$where .= " AND daily_stock_id = '".$dailyStockId."' ";
	$pageVars.= '&stock_id='.$dailyStockId.'&';
}



if(isset($_REQUEST['date_to']) && strlen($_REQUEST['date_to'])>0) {
		$to_date = trim($_REQUEST['date_to']);
		if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$to_date)) {
		    //ok - yyy-mm-dd
		} else {
		    $dateArr = explode('-', $to_date);
			$to_date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
		}
} else {
		$to_date = '';
}

if(isset($_REQUEST['from_date']) && strlen($_REQUEST['from_date'])>0) {
		$from_date = trim($_REQUEST['from_date']);
		if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$from_date)) {
		    //ok - yyy-mm-dd
		} else {
		    $dateArr = explode('-', $from_date);
			$from_date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
		}
} else {
		$from_date = '';
}

if(isset($_REQUEST['date']) && strlen($_REQUEST['date'])>0) {
		$date = trim($_REQUEST['date']);
		if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$date)) {
		    //ok - yyy-mm-dd
		} else {
		    $dateArr = explode('-', $date);
			$date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
		}
} else {
		$date = '';
}

$curDate = date('Y-m-d');

if($from_date!='' && $to_date!=''){
	$where .= " AND task_date BETWEEN '".$from_date."' AND '".$to_date."' ";
	$prodwhere .= " AND task_date BETWEEN '".$from_date."' AND '".$to_date."' ";
	$pageVars.= '&from_date='.$_REQUEST['from_date'].'&date_to='.$_REQUEST['date_to'].'&';
} else if($from_date!=''){	
	$where .= " AND task_date BETWEEN '".$from_date."' AND '".$curDate."' ";
	$prodwhere .= " AND task_date BETWEEN '".$from_date."' AND '".$curDate."' ";
	$pageVars.= '&from_date='.$_REQUEST['from_date'].'&';
} else if($to_date!=''){	
	$where .= " AND task_date BETWEEN '".$to_date."' AND '".$curDate."' ";
	$prodwhere .= " AND task_date BETWEEN '".$to_date."' AND '".$curDate."' ";
	$pageVars.= '&date_to='.$_REQUEST['date_to'].'&';
} else if($date!=''){	
	$where .= " AND task_date = '".$date."' ";
	$prodwhere .= " AND task_date = '".$date."' ";
	$pageVars.= '&date='.$_REQUEST['date'].'&';
} 

if(isset($_REQUEST['pay_type']) && strlen($_REQUEST['pay_type'])>0) {
	$payType = $_REQUEST['pay_type'];
	$where .= " AND id IN (SELECT job_id FROM tbl_technician_payments WHERE payment_method = '".$payType."') ";	 	
	$pageVars.= 'pay_type='.$payType.'&';
}

if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='orderid_asc'){
	$orderBy = " ORDER BY id ASC ";
	$pageVars.= 'orderby=orderid_asc&';
} else if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='orderid_dsc'){
	$orderBy = " ORDER BY id DESC ";
	$pageVars.= 'orderby=orderid_dsc&';
} else if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='booked_on_asc'){
	$orderBy = " ORDER BY date ASC ";
	$pageVars.= 'orderby=booked_on_asc&';
} else if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='booked_on_dsc'){
	$orderBy = " ORDER BY date DESC ";
	$pageVars.= 'orderby=booked_on_dsc&';
} else if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='booked_for_asc'){
	$orderBy = " ORDER BY task_date ASC, task_time ASC ";
	$pageVars.= 'orderby=booked_for_asc&';
} else if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='booked_for_dsc'){
	$orderBy = " ORDER BY task_date DESC, task_time DESC ";
	$pageVars.= 'orderby=booked_for_dsc&';
} else if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='status_asc'){
	$orderBy = " ORDER BY status ASC ";
	$pageVars.= 'orderby=status_asc&';
} else if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='status_dsc'){
	$orderBy = " ORDER BY status DESC ";
	$pageVars.= 'orderby=status_dsc&';
} 

if(isset($_REQUEST['prod_id']) && $_REQUEST['prod_id']!='') {
	$prodId = trim($_REQUEST['prod_id']);	
	$prodwhere .= " AND prod_id = '".$prodId."' ";	
	$where .= " AND prod_id = '".$prodId."' ";	
	$pageVars.= 'prod_id='.$prodId.'&';
} else {
	$prodwhere .= " AND prod_id > '0' ";	
}



if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='customer_asc'){
	$orderBy = " ORDER BY user_id ASC ";
	$pageVars.= 'orderby=customer_asc&';
	$select = "SELECT j.* FROM `tbl_job` j INNER JOIN tbl_user u ON j.user_id = u.id WHERE j.id > 0 ".$where." AND j.user_id=u.id ORDER BY u.name ";
} else if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='customer_dsc'){
	$orderBy = " ORDER BY user_id DESC ";
	$pageVars.= 'orderby=customer_dsc&';
	$select = "SELECT j.* FROM `tbl_job` j INNER JOIN tbl_user u ON j.user_id = u.id WHERE j.id > 0 ".$where." AND j.user_id=u.id ORDER BY u.name DESC ";
} else {
	$select = "SELECT * FROM tbl_job WHERE id > 0 ".$where.$orderBy;
}

//$select = "SELECT * FROM tbl_job WHERE user_id IN (SELECT DISTINCT id FROM tbl_user WHERE status != 'Deleted') ".$where." ORDER BY id DESC";
/*if($_SERVER['REMOTE_ADDR']=='202.88.237.77'){
	echo($select);
}*/	
	
	$soldCountRec = mysqli_fetch_array(mysqli_query($con, "SELECT SUM(quantity) AS quantity FROM tbl_job WHERE ".$prodwhere." AND status = 'paid' "));
	//echo "SELECT SUM(quantity) AS quantity FROM tbl_job WHERE status = 'paid' ".$prodwhere." ";


// Using pagination class
$pagination = new pagination_noseo($select);
$execDetails = $pagination->createPages(30, $con);

$pageLnk = 'index.php?page='.$page.'&'.$pageVars;
$pageNums = $pagination->pageNumber(5, $pageLnk);


if(isset($_POST['export'])) {
	include '../export/DBController.php';
	$db_handle = new DBController();
	//echo "SELECT id, user_id, date, task_date, task_time, status FROM tbl_job WHERE id > 0 ".$where." ORDER BY id DESC"; exit;
	$productResult = $db_handle->runQuery("SELECT id, daily_stock_id, user_id, prod_id, technician_id, quantity, unit_price, tax_percent, tax_amount, status, date, task_date, task_time, now FROM tbl_job WHERE id > 0 ".$where." ORDER BY id DESC");
	
    $filename = "AdLPG-Orders-".time().".xls";
    header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"$filename\"");
    $isPrintHeader = false;
	$label = array('0'=>'Order ID','1'=>'Customer', '2'=>'Driver', '3'=>'Vehicle','4'=>'Booked On','5'=>'Booked For','6'=>'Status','7'=>'Cylinder Size','8'=>'Unit Price','9'=>'VAT(%)','10'=>'Quantity','11'=>'Total Amount');
    if (! empty($productResult)) {
        foreach ($productResult as $row) {
        	
			//get vehicle, driver
			$vehicleId = $cylinderSize = '';
			$unitPrice = $vatPercent = $vatAmount = $prodQuantity = $totalAmount = 0;
			$driverId = $row['technician_id'];			
			if($row['daily_stock_id']>0){
				$dailyStockRec = mysqli_fetch_array(mysqli_query($con, "SELECT vehicle_id FROM tbl_daily_stock WHERE id = '".$row['daily_stock_id']."'"));
				$vehicleId = $dailyStockRec['vehicle_id'];
			} else if($row['technician_id']>0){
				$dailyStockRs = mysqli_query($con, "SELECT vehicle_id FROM tbl_daily_stock WHERE driver_id = '".$row['technician_id']."' AND closed = 'no'");
				if(mysqli_num_rows($dailyStockRs)>0){
					$dailyStockRec = mysqli_fetch_array($dailyStockRs);
					$vehicleId = $dailyStockRec['vehicle_id'];
				}
			}

			if($row['prod_id']>0){
				$cylinderSize = getProductName($row['prod_id']);
			}
			$unitPrice = $row['unit_price'];
			$vatPercent = $row['tax_percent'];
			$vatAmount = $row['tax_amount'];
			$totalAmount = ($unitPrice*$row['quantity'])+$vatAmount;
			$totalAmount = number_format((float)$totalAmount, 2, '.', '');
			
		
            if (! $isPrintHeader) {
                //echo implode("\t", array_keys($row)) . "\n";
				echo implode("\t", $label) . "\n";
                $isPrintHeader = true;				
            } 				
				//echo implode("\t", array_values($row)) . "\n"; 
				if($row['status']=='assigned'){
					$orderStatVal = 'Assigned';
				} else if($row['status']=='start_off'){
					$orderStatVal = 'On the way';
				} else if($row['status']=='arrived'){
					$orderStatVal = 'Arrived';
				} else if($row['status']=='completed'){
					$orderStatVal = 'Delivered';
				} else if($row['status']=='paid'){
					$orderStatVal = 'Payment Completed';
				} else if($row['status']=='New'){
					if($row['now']=='yes'){
						$orderStatVal = 'New';
					} else {
						$orderStatVal = 'Scheduled';
					}					
				} else {
					$orderStatVal = $row['status'];
				}
 
				echo '#'.$row['id']."\t";
				echo getUserName($row['user_id'])."\t";
				echo getDriverName($driverId)."\t";
				if($vehicleId!=''){
					echo getVehicleNumber($vehicleId)."\t";
				} else {
					echo "\t";
				}				
				echo getFormattedDateTime($row['date'])."\t";
				echo getFormattedDateTime($row['task_date'].' '.$row['task_time'])."\t";				
				echo $orderStatVal."\t";
				echo $cylinderSize."\t";
				echo $unitPrice."\t";
				echo $vatPercent."%\t";
				echo $row['quantity']."\t";
				echo $totalAmount."\t";
				echo "\n";
					//$colCount++;        
            
        }
    }
    exit();
}



if(isset($_REQUEST['export_count'])) {	
	
	require_once 'classes/PHPExcel.php';
 	$objPHPExcel = new PHPExcel();	
		
	$objPHPExcel->setActiveSheetIndex(0); 
	// Initialise the Excel row number
	$rowCount = 1; 
	$col = 1;	
	$dailyStockRs = mysqli_query($con, "SELECT DISTINCT date FROM `tbl_daily_stock` WHERE closed = 'no' ORDER BY date");
	if(mysqli_num_rows($dailyStockRs)>0){
		//create header
		$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'DATE');
		$vehicleRs = mysqli_query($con, "SELECT id FROM tbl_vehicle");
		while($vehicleRec = mysqli_fetch_array($vehicleRs)){
			$productTypeRs = mysqli_query($con, "SELECT id FROM tbl_products");
			while($productTypeRec = mysqli_fetch_array($productTypeRs)){
				$colVal = getVehicleNumber($vehicleRec['id']).'\n'.getProductName($productTypeRec['id']);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col, $rowCount, $colVal);
				$col++;
			}			
		}
		$rowCount = 2;
		$col = 2;
		//create rows
		while($dailyStockRec = mysqli_fetch_array($dailyStockRs)){			
			$date = $dailyStockRec['date']; 
			//$objPHPExcel->getActiveSheet()->SetCellValue('A2', $date);
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $date);
			$vehicleRs = mysqli_query($con, "SELECT id FROM tbl_vehicle");
			while($vehicleRec = mysqli_fetch_array($vehicleRs)){				
				$vehicleId = $vehicleRec['id'];
				$productTypeRs = mysqli_query($con, "SELECT id FROM tbl_products");
				while($productTypeRec = mysqli_fetch_array($productTypeRs)){
					//get sold count of this product on the date. If no product sold, put zero
					if($_SERVER['REMOTE_ADDR']=='202.88.237.77'){
						//echo "SELECT SUM(quantity) AS quantity FROM tbl_job WHERE task_date = '".$date."' AND prod_id = '".$productTypeRec['id']."' AND vehicle_id = '".$vehicleId."' AND status = 'paid'";
						//exit;
						$orderRec = mysqli_fetch_array(mysqli_query($con, "SELECT SUM(quantity) AS quantity FROM tbl_job WHERE task_date = '2019-10-14' AND prod_id = '".$productTypeRec['id']."' AND vehicle_id = '".$vehicleId."' AND status = 'paid'"));
					} else {
						$orderRec = mysqli_fetch_array(mysqli_query($con, "SELECT SUM(quantity) AS quantity FROM tbl_job WHERE task_date = '".$date."' AND prod_id = '".$productTypeRec['id']."' AND vehicle_id = '".$vehicleId."' AND status = 'paid'"));
					}
					
					$colVal = $orderRec['quantity'];
					$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col, $rowCount, $colVal);
					$col++;
				}
			}
			$rowCount++;
		}		
	}	
	header('Content-Type: application/vnd.ms-excel'); 
	header('Content-Disposition: attachment;filename="AdLPG-Order-Vehicle-'.time().'.xls"'); 
	header('Cache-Control: max-age=0'); 
	$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5'); 
	$objWriter->save('php://output');  
	
	//to set cell color
	/*$sheet->getStyle('A1')->applyFromArray(
	    array(
	        'fill' => array(
	            'type' => PHPExcel_Style_Fill::FILL_SOLID,
	            'color' => array('rgb' => 'FF0000')
	        )
	    )
	);*/
}
?>