<?php
/*
* date last modified 28-11-2017
* Edited by PI-Digi Logical Solutions
* HTML Files - add_user.html.php
* Mysql Tables - tbl_designation, tbl_technician
*/
include('includes/imgFunctions.php');
include('includes/functions.php'); # general functions
include('includes/push_functions.php'); 


$isEdit = FALSE;
$latitude = $longitude = '';
$curDate = date('Y-m-d H:i:s');		

//get cities
$citiesRs = mysqli_query($con, "SELECT id, name FROM tbl_city ORDER BY name");

//get list of all operators
$operatorRs = mysqli_query($con, "SELECT id, name FROM tbl_technician WHERE operator = 'yes' AND status = 'Active' ORDER BY name");


if(isset($_REQUEST['id']) && $_REQUEST['id']!=''){
	
	$isEdit = TRUE;
	$editId = mysqli_real_escape_string($con, trim($_REQUEST['id']));
	
	//get license categories if added
	$licenseCatArray = array();
	$licenseCatRs = mysqli_query($con, "SELECT cat_id FROM tbl_tech_licensed WHERE tech_id = '".$editId."'");
	if(mysqli_num_rows($licenseCatRs)>0){
		while($licenseCatRec = mysqli_fetch_array($licenseCatRs)){
			$licenseCatArray[] = $licenseCatRec['cat_id'];
		}
	}
	
	//delete image1
	if(isset($_REQUEST['action']) && $_REQUEST['action']=='del_image1'){
		$recImg = mysqli_fetch_array(mysqli_query($con, "SELECT image1 FROM tbl_technician WHERE id = '".$editId."'"));
		if(($recImg['image1']!='') && file_exists(TECH_IMG_FOLDER.$recImg['image1'])){
			unlink(TECH_IMG_FOLDER.$recImg['image1']);
			unlink(TECH_IMG_FOLDER.'thumb/'.$recImg['image1']);
		}
		$update = mysqli_query($con, "UPDATE tbl_technician SET image1 = '' WHERE id = '".$editId."'");
		$success = 'Image1 has been deleted';
	}	
	//delete image2
	if(isset($_REQUEST['action']) && $_REQUEST['action']=='del_image2'){
		$recImg = mysqli_fetch_array(mysqli_query($con, "SELECT image2 FROM tbl_technician WHERE id = '".$editId."'"));
		if(($recImg['image2']!='') && file_exists(TECH_IMG_FOLDER.$recImg['image2'])){
			unlink(TECH_IMG_FOLDER.$recImg['image2']);
			unlink(TECH_IMG_FOLDER.'thumb/'.$recImg['image2']);
		}
		$update = mysqli_query($con, "UPDATE tbl_technician SET image2 = '' WHERE id = '".$editId."'");
		$success = 'Image2 has been deleted';
	}
	//delete image3
	if(isset($_REQUEST['action']) && $_REQUEST['action']=='del_image3'){
		$recImg = mysqli_fetch_array(mysqli_query($con, "SELECT image3 FROM tbl_technician WHERE id = '".$editId."'"));
		if(($recImg['image3']!='') && file_exists(TECH_IMG_FOLDER.$recImg['image3'])){
			unlink(TECH_IMG_FOLDER.$recImg['image3']);
			unlink(TECH_IMG_FOLDER.'thumb/'.$recImg['image3']);
		}
		$update = mysqli_query($con, "UPDATE tbl_technician SET image3 = '' WHERE id = '".$editId."'");
		$success = 'Image3 has been deleted';
	}
	
	$editRs = mysqli_query($con, "SELECT * FROM tbl_technician WHERE id = '".$editId."'");
	if(mysqli_num_rows($editRs)>0){
		$resEdit = mysqli_fetch_array($editRs);
		$latitude = $resEdit['latitude'];
		$longitude = $resEdit['longitude'];
		if($latitude!='' && $longitude!=''){
			//ok
		} else {
			$latitude = '8.5241391';
			$longitude = '76.9366376';
		}
	} else {
		$error = 'Technicain does not exist!';
	}

} 

if(isset($_POST['add'])) {
		
	if(isset($_FILES['photo3']) && $_FILES['photo3']['size'] > 0) {		
		if($_FILES['photo3']['type'] == 'image/gif' || $_FILES['photo3']['type'] == 'image/jpeg' || 
		   $_FILES['photo3']['type'] == 'image/png' || $_FILES['photo3']['type'] == 'image/pjpeg') {
			$photo3_name = $_FILES['photo3']['name'];			
			$photo3_temp_name = $_FILES['photo3']['tmp_name'];
			$photo3_extension = pathinfo($photo3_name, PATHINFO_EXTENSION);
		} else {
			$photo3_name = FALSE;
			$photo3_temp_name = FALSE;
			$error = "Invalid Image type for Image3. Only gif, jpg and png allowed";
		}
	}
	
	if(isset($_FILES['photo2']) && $_FILES['photo2']['size'] > 0) {		
		if($_FILES['photo2']['type'] == 'image/gif' || $_FILES['photo2']['type'] == 'image/jpeg' || 
		   $_FILES['photo2']['type'] == 'image/png' || $_FILES['photo2']['type'] == 'image/pjpeg') {
			$photo2_name = $_FILES['photo2']['name'];			
			$photo2_temp_name = $_FILES['photo2']['tmp_name'];
			$photo2_extension = pathinfo($photo2_name, PATHINFO_EXTENSION);
		} else {
			$photo2_name = FALSE;
			$photo2_temp_name = FALSE;
			$error = "Invalid Image type for Image2. Only gif, jpg and png allowed";
		}
	}
	
	if(isset($_FILES['photo1']) && $_FILES['photo1']['size'] > 0) {		
		if($_FILES['photo1']['type'] == 'image/gif' || $_FILES['photo1']['type'] == 'image/jpeg' || 
		   $_FILES['photo1']['type'] == 'image/png' || $_FILES['photo1']['type'] == 'image/pjpeg') {
			$photo1_name = $_FILES['photo1']['name'];			
			$photo1_temp_name = $_FILES['photo1']['tmp_name'];
			$photo1_extension = pathinfo($photo1_name, PATHINFO_EXTENSION);
		} else {
			$photo1_name = FALSE;
			$photo1_temp_name = FALSE;
			$error = "Invalid Image type for Image1. Only gif, jpg and png allowed";
		}
	}
	
	
	if(isset($_POST['night_work']) && strlen(trim($_POST['night_work'])) > 0) {
		$night_work = trim($_POST['night_work']);		
	} else {
		$night_work = '';
	}
	
	if(isset($_POST['licensed']) && strlen(trim($_POST['licensed'])) > 0) {
		$licensed = trim($_POST['licensed']);				
	} else {
		$licensed = '';
	}

	if(isset($_POST['birth_year']) && strlen(trim($_POST['birth_year'])) > 0) {
		$birth_year = trim($_POST['birth_year']);		
		if(is_numeric($birth_year) && $birth_year>1900 && $birth_year<date('Y')){
			//ok
		} else {
			$error = 'Please enter a valid birth year';
		}
	} else {
		$birth_year = '';
	}

	if(isset($_POST['smartphone']) && strlen(trim($_POST['smartphone'])) > 0) {
		$smartphone = trim($_POST['smartphone']);		
	} else {
		$smartphone = '';
	}

	if(isset($_POST['bike_license']) && strlen(trim($_POST['bike_license'])) > 0) {
		$bike_license = trim($_POST['bike_license']);		
	} else {
		$bike_license = '';
	}

	if(strlen(trim($_POST['mobile2'])) > 0) {
		$mobile2 = trim($_POST['mobile2']);		
	} else {
		$mobile2 = '';
	}
	
	if(strlen(trim($_POST['city'])) > 0) {
		$city = trim($_POST['city']);
	} else {
		$error = 'Please select City';
	}
	
	if(strlen(trim($_POST['pin'])) > 0) {
		$pin = trim($_POST['pin']);		
	} else {
		$error = 'Please enter PIN Code';
	}
	
	if(strlen(trim($_POST['longitude'])) > 0) {
		$longitude = trim($_POST['longitude']);		
	} else {
		$longitude = '';			
	}
	
	if(strlen(trim($_POST['latitude'])) > 0) {
		$latitude = trim($_POST['latitude']);		
	} else {
		$latitude = '';			
	}
	
	if(strlen(trim($_POST['place'])) > 0) {
		$place = trim($_POST['place']);			
	} else {
		$error = 'Please enter Place';
	}
	
	if(strlen(trim($_POST['street'])) > 0) {
		$street = trim($_POST['street']);
	} else {
		$street = '';
	}
	
	if(strlen(trim($_POST['house_name'])) > 0) {
		$house_name = trim($_POST['house_name']);
	} else {
		$error = 'Please enter House Name';
	}	
			
	if(strlen(trim($_POST['phone'])) > 0) {
		$phone = trim($_POST['phone']);
		if(is_numeric($phone) && strlen($phone)>9 && strlen($phone)<15){
			// check Email
			$checkPhone = mysqli_query($con,"SELECT id FROM tbl_technician WHERE phone='".mysqli_real_escape_string($con,$phone)."' AND status != 'Deleted' ");
			if(isset($checkPhone) && mysqli_num_rows($checkPhone)>0) {
				$error = 'A technician with the same phone number exists';
			}
		} else {
			$error = 'Please enter phone number only digits with coutry code';
		}
	} else {
		$error = 'Please enter Phone Number';
	}

	if(strlen(trim($_POST['re_password'])) > 0) {
		$re_password = trim($_POST['re_password']);
		if(strlen(trim($_POST['password'])) > 0) {
			$password = trim($_POST['password']);
			if($password == $re_password){
				//ok
			} else {
				$error = 'Password mis-match error!';
			}
		}
	} else {
		$error = 'Please re-enter Password';
	}

	if(strlen(trim($_POST['password'])) > 0) {
		$password = trim($_POST['password']);
		if(strlen($password)>5){
			//ok
		} else {
			$error = 'Password should contain atleast 6 characters';
		}
	} else {
		$error = 'Please enter Password';
	}
	
	if(isset($_POST['email']) && strlen(trim($_POST['email'])) > 0) {
		$email = trim($_POST['email']);
		if(!filter_var($email, FILTER_VALIDATE_EMAIL)){
			$error =  "E-mail is not valid";
		} else {
			// check Email
			$checkEmail = mysqli_query($con,"SELECT id FROM tbl_technician WHERE email='".mysqli_real_escape_string($con,$email)."' AND status != 'Deleted' ");
			if(isset($checkEmail) && mysqli_num_rows($checkEmail)>0) {
				$error = 'Email Already Taken';
			}
		}
	} else {
		//$error = 'Please enter Email';
		$email = '';
	}
	
	if(isset($_POST['name']) && strlen($_POST['name'])>0) {
		$name = trim($_POST['name']);
	} else {
		$error = 'Please Enter Name';
	}	
	
	if(isset($_POST['type']) && strlen($_POST['type'])>0) {
		$type = trim($_POST['type']);
	} else {
		$error = 'Please Select Technician Type';
	}
	
	if(empty($error)) {
		
		$mapPlace = $_POST['place'];		
		$latLong = getLatLong($mapPlace);
		//print_r($latLong);
		//exit;
		if($latitude!='' && $longitude!=''){
			//take the values
		} else if(is_array($latLong) && $latLong['latitude']!='' && $latLong['longitude']!=''){
			//ok
			$latitude = $latLong['latitude'];
			$longitude = $latLong['longitude'];
		} else {
			$error = 'Unable to find lat-long from the location - '.$mapPlace.'. Try again';
		}
		
		if(empty($error)) {
							
			/* Adding New User Details */		
			$insertQry = "INSERT INTO tbl_technician(type, name, email, password, phone, house_name, street, place, pin, city, date, operator, latitude, longitude, status, added_by,availability) VALUES (
			'".mysqli_real_escape_string($con, $type)."',
			'".mysqli_real_escape_string($con, $name)."',
			 '".mysqli_real_escape_string($con, $email)."',
			 '".mysqli_real_escape_string($con, $password)."',
			 '".mysqli_real_escape_string($con, $phone)."',	
			 '".mysqli_real_escape_string($con, $house_name)."',
			 '".mysqli_real_escape_string($con, $street)."',
			 '".mysqli_real_escape_string($con, $place)."',
			 '".mysqli_real_escape_string($con, $pin)."',
			 '".mysqli_real_escape_string($con, $city)."',
			 '".$curDate."',
			 'no',
			 '".mysqli_real_escape_string($con, $latitude)."',
			 '".mysqli_real_escape_string($con, $longitude)."',			 
			 'Active',
			 '".$_SESSION['adminId']."','on')";
			
			$execInsert = mysqli_query($con,$insertQry);
			$insert_id = mysqli_insert_id($con);		
			
			if($execInsert) {
					
				$updateQry = "UPDATE tbl_technician SET mobile2 = '".$mobile2."', bike_license = '".$bike_license."', smartphone = '".$smartphone."', birth_year = '".$birth_year."', licensed = '".$licensed."', night_work = '".$night_work."', availability = 'on'  WHERE id = '".$insert_id."'";
				$execUpdate = mysqli_query($con,$updateQry);
				
				if(isset($_FILES['photo1']) && $_FILES['photo1']['size'] > 0) {
					$photo1_dir =TECH_IMG_FOLDER;
					$photo1_name = $insert_id.'_1_'.time().'.'.$photo1_extension; 
					if(move_uploaded_file($photo1_temp_name, $photo1_dir.$photo1_name)){
						resize2(TECH_IMG_FOLDER.$photo1_name, 200, 150, TECH_IMG_FOLDER.'thumb/'.$photo1_name);						
						mysqli_query($con, "UPDATE tbl_technician SET image1 = '".$photo1_name."' WHERE id = ".$insert_id);						
					}			
				}	
				if(isset($_FILES['photo2']) && $_FILES['photo2']['size'] > 0) {
					$photo2_dir = TECH_IMG_FOLDER;
					$photo2_name = $insert_id.'_2_'.time().'.'.$photo2_extension; 
					if(move_uploaded_file($photo2_temp_name, $photo2_dir.$photo2_name)){
						resize2(TECH_IMG_FOLDER.$photo2_name, 200, 150, TECH_IMG_FOLDER.'thumb/'.$photo2_name);						
						mysqli_query($con, "UPDATE tbl_technician SET image2 = '".$photo2_name."' WHERE id = ".$insert_id);						
					}			
				}
				if(isset($_FILES['photo3']) && $_FILES['photo3']['size'] > 0) {
					$photo3_dir = TECH_IMG_FOLDER;
					$photo3_name = $insert_id.'_3_'.time().'.'.$photo3_extension; 
					if(move_uploaded_file($photo3_temp_name, $photo3_dir.$photo3_name)){
						resize2(TECH_IMG_FOLDER.$photo3_name, 200, 150, TECH_IMG_FOLDER.'thumb/'.$photo3_name);						
						mysqli_query($con, "UPDATE tbl_technician SET image3 = '".$photo3_name."' WHERE id = ".$insert_id);						
					}			
				}					
				$technicianId = $insert_id;
				//add license of electrician,plumbing
				if(isset($_POST['license_cat'])){
					foreach ($_POST['license_cat'] as $licenseCatId) {
						mysqli_query($con, "INSERT INTO tbl_tech_licensed (tech_id, cat_id) VALUES ('".$technicianId."', '".$licenseCatId."')");
					}
				}
				
				//make availability for week days
				
				//$slotTimes = array('08:00:00-10:00:00', '10:00:00-12:00:00', '12:00:00-14:00:00', '14:00:00-16:00:00', '16:00:00-18:00:00');
				//monday									
					/*if(isset($_POST['monday_time']) && is_array($_POST['monday_time'])){
						foreach ($slotTimes as $slot) {
							$slotArr = explode('-', $slot);
							$startTime = $slotArr[0];
							$endTime = $slotArr[1];
							mysqli_query($con, "INSERT INTO tbl_technician_availability (technician_id, day, start_time, end_time, status) VALUES ('".$technicianId."', 'monday', '".$startTime."', '".$endTime."', 'on')");
						}
					} else {
						$error = "Please select atleast one slot for Monday";
					}*/
				
				$availabilityQry = "INSERT INTO `tbl_technician_availability` (`technician_id`, `day`, `start_time`, `end_time`, `status`) VALUES
					('".$technicianId."', 'monday', '08:00:00', '10:00:00', 'on'),
					('".$technicianId."', 'monday', '10:00:00', '12:00:00', 'on'),
					('".$technicianId."', 'monday', '12:00:00', '14:00:00', 'on'),
					('".$technicianId."', 'monday', '14:00:00', '16:00:00', 'on'),
					('".$technicianId."', 'monday', '16:00:00', '18:00:00', 'on'),
					('".$technicianId."', 'tuesday', '08:00:00', '10:00:00', 'on'),
					('".$technicianId."', 'tuesday', '10:00:00', '12:00:00', 'on'),
					('".$technicianId."', 'tuesday', '12:00:00', '14:00:00', 'on'),
					('".$technicianId."', 'tuesday', '14:00:00', '16:00:00', 'on'),
					('".$technicianId."', 'tuesday', '16:00:00', '18:00:00', 'on'),
					('".$technicianId."', 'wednesday', '08:00:00', '10:00:00', 'on'),
					('".$technicianId."', 'wednesday', '10:00:00', '12:00:00', 'on'),
					('".$technicianId."', 'wednesday', '12:00:00', '14:00:00', 'on'),
					('".$technicianId."', 'wednesday', '14:00:00', '16:00:00', 'on'),
					('".$technicianId."', 'wednesday', '16:00:00', '18:00:00', 'on'),
					('".$technicianId."', 'thursday', '08:00:00', '10:00:00', 'on'),
					('".$technicianId."', 'thursday', '10:00:00', '12:00:00', 'on'),
					('".$technicianId."', 'thursday', '12:00:00', '14:00:00', 'on'),
					('".$technicianId."', 'thursday', '14:00:00', '16:00:00', 'on'),
					('".$technicianId."', 'thursday', '16:00:00', '18:00:00', 'on'),
					('".$technicianId."', 'friday', '08:00:00', '10:00:00', 'on'),
					('".$technicianId."', 'friday', '10:00:00', '12:00:00', 'on'),
					('".$technicianId."', 'friday', '12:00:00', '14:00:00', 'on'),
					('".$technicianId."', 'friday', '14:00:00', '16:00:00', 'on'),
					('".$technicianId."', 'friday', '16:00:00', '18:00:00', 'on'),
					('".$technicianId."', 'saturday', '08:00:00', '10:00:00', 'on'),
					('".$technicianId."', 'saturday', '10:00:00', '12:00:00', 'on'),
					('".$technicianId."', 'saturday', '12:00:00', '14:00:00', 'on'),
					('".$technicianId."', 'saturday', '14:00:00', '16:00:00', 'on'),
					('".$technicianId."', 'saturday', '16:00:00', '18:00:00', 'on')";
				
				mysqli_query($con, $availabilityQry);
										
				$success = 'Technician Added Successfully';
				header('Location:index.php?page=manage_technician&success='.$success);
				exit();			
			} else {
				$error = 'Unable to add techniacian';
			}		
		}		
	} 
}

if(isset($_POST['update'])) {
	
	if(isset($_FILES['photo3']) && $_FILES['photo3']['size'] > 0) {		
		if($_FILES['photo3']['type'] == 'image/gif' || $_FILES['photo3']['type'] == 'image/jpeg' || 
		   $_FILES['photo3']['type'] == 'image/png' || $_FILES['photo3']['type'] == 'image/pjpeg') {
			$photo3_name = $_FILES['photo3']['name'];			
			$photo3_temp_name = $_FILES['photo3']['tmp_name'];
			$photo3_extension = pathinfo($photo3_name, PATHINFO_EXTENSION);
		} else {
			$photo3_name = FALSE;
			$photo3_temp_name = FALSE;
			$error = "Invalid Image type for Image3. Only gif, jpg and png allowed";
		}
	}
	
	if(isset($_FILES['photo2']) && $_FILES['photo2']['size'] > 0) {		
		if($_FILES['photo2']['type'] == 'image/gif' || $_FILES['photo2']['type'] == 'image/jpeg' || 
		   $_FILES['photo2']['type'] == 'image/png' || $_FILES['photo2']['type'] == 'image/pjpeg') {
			$photo2_name = $_FILES['photo2']['name'];			
			$photo2_temp_name = $_FILES['photo2']['tmp_name'];
			$photo2_extension = pathinfo($photo2_name, PATHINFO_EXTENSION);
		} else {
			$photo2_name = FALSE;
			$photo2_temp_name = FALSE;
			$error = "Invalid Image type for Image2. Only gif, jpg and png allowed";
		}
	}
	
	if(isset($_FILES['photo1']) && $_FILES['photo1']['size'] > 0) {		
		if($_FILES['photo1']['type'] == 'image/gif' || $_FILES['photo1']['type'] == 'image/jpeg' || 
		   $_FILES['photo1']['type'] == 'image/png' || $_FILES['photo1']['type'] == 'image/pjpeg') {
			$photo1_name = $_FILES['photo1']['name'];			
			$photo1_temp_name = $_FILES['photo1']['tmp_name'];
			$photo1_extension = pathinfo($photo1_name, PATHINFO_EXTENSION);
		} else {
			$photo1_name = FALSE;
			$photo1_temp_name = FALSE;
			$error = "Invalid Image type for Image1. Only gif, jpg and png allowed";
		}
	}

	if(isset($_POST['night_work']) && strlen(trim($_POST['night_work'])) > 0) {
		$night_work = trim($_POST['night_work']);		
	} else {
		$night_work = '';
	}
	
	if(isset($_POST['licensed']) && strlen(trim($_POST['licensed'])) > 0) {
		$licensed = trim($_POST['licensed']);		
	} else {
		$licensed = '';
	}

	if(isset($_POST['birth_year']) && strlen(trim($_POST['birth_year'])) > 0) {
		$birth_year = trim($_POST['birth_year']);		
		if(is_numeric($birth_year) && $birth_year>1900 && $birth_year<date('Y')){
			//ok
		} else {
			$error = 'Please enter a valid birth year';
		}
	} else {
		$birth_year = '';
	}

	if(isset($_POST['smartphone']) && strlen(trim($_POST['smartphone'])) > 0) {
		$smartphone = trim($_POST['smartphone']);		
	} else {
		$smartphone = '';
	}

	if(isset($_POST['bike_license']) && strlen(trim($_POST['bike_license'])) > 0) {
		$bike_license = trim($_POST['bike_license']);		
	} else {
		$bike_license = '';
	}

	if(strlen(trim($_POST['mobile2'])) > 0) {
		$mobile2 = trim($_POST['mobile2']);		
	} else {
		$mobile2 = '';
	}
		
	if(strlen(trim($_POST['city'])) > 0) {
		$city = trim($_POST['city']);
	} else {
		$error = 'Please select City';
	}
	
	if(strlen(trim($_POST['pin'])) > 0) {
		$pin = trim($_POST['pin']);		
	} else {
		$error = 'Please enter PIN Code';
	}
	
	if(strlen(trim($_POST['longitude'])) > 0) {
		$longitude = trim($_POST['longitude']);		
	} else {
		$longitude = '';			
	}
	
	if(strlen(trim($_POST['latitude'])) > 0) {
		$latitude = trim($_POST['latitude']);		
	} else {
		$latitude = '';			
	}
	
	if(strlen(trim($_POST['place'])) > 0) {
		$place = trim($_POST['place']);			
	} else {
		$error = 'Please enter Place';
	}
	
	if(strlen(trim($_POST['street'])) > 0) {
		$street = trim($_POST['street']);
	} else {
		$street = '';
	}
	
	if(strlen(trim($_POST['house_name'])) > 0) {
		$house_name = trim($_POST['house_name']);
	} else {
		$error = 'Please enter House Name';
	}	
				
	if(strlen(trim($_POST['phone'])) > 0) {
		$phone = trim($_POST['phone']);
		if(is_numeric($phone) && strlen($phone)>9 && strlen($phone)<15){
			// check 
			$checkPhone = mysqli_query($con,"SELECT id FROM tbl_technician WHERE phone='".mysqli_real_escape_string($con,$phone)."' AND status != 'Deleted' AND id != '".$editId."' ");
			if(isset($checkPhone) && mysqli_num_rows($checkPhone)>0) {
				$error = 'A technician with the same phone number exists';
			}
		} else {
			$error = 'Please enter phone number only digits with coutry code';
		}
	} else {
		$error = 'Please enter Phone Number';
	}

	/*if(strlen(trim($_POST['re_password'])) > 0) {
		$re_password = trim($_POST['re_password']);
		if(strlen(trim($_POST['password'])) > 0) {
			$password = trim($_POST['password']);
			if($password == $re_password){
				//ok
			} else {
				$error = 'Password mis-match error!';
			}
		}
	} else {
		$error = 'Please re-enter Password';
	}

	if(strlen(trim($_POST['password'])) > 0) {
		$password = trim($_POST['password']);
	} else {
		$error = 'Please enter Password';
	}*/
	
	if(isset($_POST['email']) && strlen(trim($_POST['email'])) > 0) {
		$email = trim($_POST['email']);
		if(!filter_var($email, FILTER_VALIDATE_EMAIL)){
			$error =  "E-mail is not valid";
		} else {
			// check Email
			$checkEmail = mysqli_query($con,"SELECT id FROM tbl_technician WHERE email='".mysqli_real_escape_string($con,$email)."' AND status != 'Deleted' AND id != '".$editId."' ");
			if(isset($checkEmail) && mysqli_num_rows($checkEmail)>0) {
				$error = 'Email Already Taken';
			}
		}
	} else {
		$error = 'Please enter Email';
	}
	
	if(isset($_POST['name']) && strlen($_POST['name'])>0) {
		$name = trim($_POST['name']);
	} else {
		$error = 'Please enter Name';
	}
	
	if(isset($_POST['type']) && strlen($_POST['type'])>0) {
		$type = trim($_POST['type']);
	} else {
		$error = 'Please Select Technician Type';
	}
	
		
	if(empty($error)) {
		
		$mapPlace = $_POST['place'];		
		$latLong = getLatLong($mapPlace);
		//print_r($latLong);
		//exit;
		if($latitude!='' && $longitude!=''){
			//take the values
		} else if(is_array($latLong) && $latLong['latitude']!='' && $latLong['longitude']!=''){
			//ok
			$latitude = $latLong['latitude'];
			$longitude = $latLong['longitude'];
		} else {
			$error = 'Unable to find lat-long from the location - '.$mapPlace.'. Try again';
		}					
		
		if(empty($error)){
			
			$updateQry = "UPDATE tbl_technician SET type = '".$type."', name = '".$name."', email = '".$email."', phone = '".$phone."', house_name = '".$house_name."', street = '".$street."', place = '".$place."', pin = '".$pin."', 
			city = '".$city."', latitude = '".$latitude."', longitude = '".$longitude."', updated_by = '".$_SESSION['adminId']."', updated_on = '".$curDate."', mobile2 = '".$mobile2."', bike_license = '".$bike_license."', smartphone = '".$smartphone."', 
			birth_year = '".$birth_year."', licensed = '".$licensed."', night_work = '".$night_work."'  WHERE id = '".$editId."'";
			/*if($_SERVER['REMOTE_ADDR']=='202.88.237.77'){
				echo $updateQry; exit;
			}*/
			$execUpdate = mysqli_query($con,$updateQry);	
			
			//add license of electrician,plumbing- before thid delete all entries of this tech
			mysqli_query($con, "DELETE FROM tbl_tech_licensed WHERE tech_id = '".$editId."'");
			if(isset($_POST['license_cat'])){
				foreach ($_POST['license_cat'] as $licenseCatId) {
					mysqli_query($con, "INSERT INTO tbl_tech_licensed (tech_id, cat_id) VALUES ('".$editId."', '".$licenseCatId."')");
				}
			}
				
			//upload images
				if(isset($_FILES['photo1']) && $_FILES['photo1']['size'] > 0) {
					$photo1_dir =TECH_IMG_FOLDER;
					$photo1_name = $editId.'_1_'.time().'.'.$photo1_extension; 
					if(move_uploaded_file($photo1_temp_name, $photo1_dir.$photo1_name)){
						resize2(TECH_IMG_FOLDER.$photo1_name, 200, 150, TECH_IMG_FOLDER.'thumb/'.$photo1_name);						
						mysqli_query($con, "UPDATE tbl_technician SET image1 = '".$photo1_name."' WHERE id = ".$editId);						
					}			
				}	
				if(isset($_FILES['photo2']) && $_FILES['photo2']['size'] > 0) {
					$photo2_dir = TECH_IMG_FOLDER;
					$photo2_name = $editId.'_2_'.time().'.'.$photo2_extension; 
					if(move_uploaded_file($photo2_temp_name, $photo2_dir.$photo2_name)){
						resize2(TECH_IMG_FOLDER.$photo2_name, 200, 150, TECH_IMG_FOLDER.'thumb/'.$photo2_name);						
						mysqli_query($con, "UPDATE tbl_technician SET image2 = '".$photo2_name."' WHERE id = ".$editId);						
					}			
				}
				if(isset($_FILES['photo3']) && $_FILES['photo3']['size'] > 0) {
					$photo3_dir = TECH_IMG_FOLDER;
					$photo3_name = $editId.'_3_'.time().'.'.$photo3_extension; 
					if(move_uploaded_file($photo3_temp_name, $photo3_dir.$photo3_name)){
						resize2(TECH_IMG_FOLDER.$photo3_name, 200, 150, TECH_IMG_FOLDER.'thumb/'.$photo3_name);						
						mysqli_query($con, "UPDATE tbl_technician SET image3 = '".$photo3_name."' WHERE id = ".$editId);						
					}			
				}		
			
			if($execUpdate) {
				
				$exec_token = mysqli_query($con, 'SELECT fcm_token, device FROM tbl_fcm_tokens WHERE tech_id='.$editId);
				if(isset($exec_token) && mysqli_num_rows($exec_token)>0) {
					while($res_token = mysqli_fetch_array($exec_token)) {	
						if($res_token['fcm_token']!='') {							
							$title = 'LiiMR';
							$body = 'Hi '.getTechnicianName($editId).', your profile details have been updated';
							if($res_token['device']=='android') {								
								//sendGCM($title, $body, $res_token['fcm_token'], "tech");
								sendGCM($title, $body, $res_token['fcm_token'], "", "", "", "", "tech");
							}							
						}
					}
				}
				
				$success = 'Technician Updated Successfully';
				header('Location:index.php?page=manage_technician&success='.$success);
				exit();			
			} else {
				$error = 'Unable to update details';
			}		
		}			
	} 
}

?>