<?php
/*
* date last modified 28-11-2017
* Edited by PI-Digi Logical Solutions
* HTML Files - add_user.html.php
* Mysql Tables - tbl_designation, tbl_staff
*/
include('includes/imgFunctions.php');
include('includes/functions.php'); # general functions
require_once('includes/push_functions.php');
include_once('PHPMailer/class.phpmailer.php');
include('../includes/auto_assign.php'); 
require_once ('../includes/order_distance_function.php');
include('includes/sms_function.php'); 

function distance($lat1, $lon1, $lat2, $lon2, $unit) {
  $theta = $lon1 - $lon2;
  $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));
  $dist = acos($dist);
  $dist = rad2deg($dist);
  $miles = $dist * 60 * 1.1515;
  $unit = strtoupper($unit);

  if ($unit == "K") {
    return ($miles * 1.609344);
  } else if ($unit == "N") {
      return ($miles * 0.8684);
    } else {
        return $miles;
      }
}

function cmp($a, $b) {
			    if ($a == $b) {
			        return 0;
			    }
			    return ($a < $b) ? -1 : 1;
}

if(isset($_POST['clear'])) { ?>
<script language="javascript" type="text/javascript">			
	window.location='index.php?page=<?php echo $page;?>';
</script>
<?php }

$isEdit = FALSE;
$debug = true;
$curDate = date('Y-m-d H:i:s');
$hasRes = FALSE;

//get all products
$productRs = mysqli_query($con, "SELECT id, name FROM tbl_products WHERE status = 'Active'");
 
if(isset($_REQUEST['p'])){
	$p = trim($_REQUEST['p']);
} else {
	$p = 1;
}


if(isset($_POST['search'])){
	
	if(isset($_POST['keyword']) && strlen($_POST['keyword'])>0) {
		$keyword = trim($_POST['keyword']);
		if(strlen($keyword)>2){
			
		} else {
			$error = 'Please enter atleast 3 characters';
		}
	} else {
		$error = 'Enter a string to search';
	}
	
	if(empty($error)){
		$userRs = mysqli_query($con, "SELECT * FROM tbl_user WHERE (name LIKE '%".$keyword."%' OR phone LIKE '%".$keyword."%' OR email LIKE '%".$keyword."%' OR additional_numbers LIKE '%".$keyword."%') AND status = 'Active' ORDER BY id DESC");
		
		$totalUserCount = mysqli_num_rows($userRs);
		
		
		if($totalUserCount=='1'){
			//get last order of the user
			$userRs2 = mysqli_query($con, "SELECT id FROM tbl_user WHERE (name LIKE '%".$keyword."%' OR phone LIKE '%".$keyword."%' OR email LIKE '%".$keyword."%' OR additional_numbers LIKE '%".$keyword."%') AND status = 'Active' ORDER BY id DESC");
			$userRec = mysqli_fetch_array($userRs2);
			$userId = $userRec['id'];
			$orderRs = mysqli_query($con, "SELECT prod_id FROM tbl_job WHERE user_id = '".$userId."' ORDER BY id DESC LIMIT 1");
			if(mysqli_num_rows($orderRs)>0){
				$orderRec = mysqli_fetch_array($orderRs);
				if($orderRec['prod_id']!='0'){
					$lastProdId = $orderRec['prod_id'];
					$quantity = 1;
					$prodRec = mysqli_fetch_array(mysqli_query($con, "SELECT price FROM tbl_products WHERE id = '".$lastProdId."'"));
					$prodPrice = $prodRec['price'];
					$settingsRec = mysqli_fetch_array(mysqli_query($con, "SELECT tax_percent FROM tbl_settings WHERE id = '1'"));
					$taxPercent = $settingsRec['tax_percent'];
					$total = $prodPrice*$quantity;
					$taxAmount = ($total*$taxPercent)/100;
					$totalAmount = $total+$taxAmount;
					$totalAmountLast = number_format((float)$totalAmount, 2, '.', '');
					$taxAmountLast = number_format((float)$taxAmount, 2, '.', '');					
				}
			}
		}
		
		
		
	}
} else if(isset($_REQUEST['customer_id']) && $_REQUEST['customer_id']!=''){
	$userId = trim($_REQUEST['customer_id']);
	$userRs = mysqli_query($con, "SELECT * FROM tbl_user WHERE id = '".$userId."'");
	//get last order details
	$orderRs = mysqli_query($con, "SELECT prod_id FROM tbl_job WHERE user_id = '".$userId."' ORDER BY id DESC LIMIT 1");
	if(mysqli_num_rows($orderRs)>0){
		$orderRec = mysqli_fetch_array($orderRs);
		if($orderRec['prod_id']!='0'){
			$lastProdId = $orderRec['prod_id'];
			$quantity = 1;
			$prodRec = mysqli_fetch_array(mysqli_query($con, "SELECT price FROM tbl_products WHERE id = '".$lastProdId."'"));
			$prodPrice = $prodRec['price'];
			$settingsRec = mysqli_fetch_array(mysqli_query($con, "SELECT tax_percent FROM tbl_settings WHERE id = '1'"));
			$taxPercent = $settingsRec['tax_percent'];
			$total = $prodPrice*$quantity;
			$taxAmount = ($total*$taxPercent)/100;
			$totalAmount = $total+$taxAmount;
			$totalAmountLast = number_format((float)$totalAmount, 2, '.', '');
			$taxAmountLast = number_format((float)$taxAmount, 2, '.', '');
			//echo $totalAmount.' (VAT: '.$taxAmount.')';
		}
	}
}



if(isset($_POST['add'])){
	$now = '';
	
	/*if($_SERVER['REMOTE_ADDR']=='202.88.237.77'){
		//print_r($_POST); 
		echo time(); 
		echo date('Y-m-d H:i'); 
		echo strtotime($_POST['date_time']);
		echo date('Y-m-d H:i');
		echo strtotime(date('Y-m-d H:i'));
		echo $_POST['date_time'];
		
	}*/
	
	if(isset($_REQUEST['quantity']) && $_REQUEST['quantity']!=''){
		$quantity = trim($_REQUEST['quantity']);
	} else {
		$error = 'Please select quantity';
	}
	
	if(isset($_REQUEST['product']) && $_REQUEST['product']!=''){
		$product = trim($_REQUEST['product']);
	} else {
		$error = 'Please select a product';
	}
		
	if(isset($_POST['order_option']) && $_POST['order_option']!=''){
		$orderOption = $_POST['order_option'];
		if($orderOption=='now'){
			$date = date('Y-m-d');
			$time = date('H:i:s');
			$now = 'yes';
		} else {
			if(isset($_POST['date_time']) && strlen($_POST['date_time'])>0) {
				$date_time = trim($_POST['date_time']);
				$dateTimeArr = explode(' ', $date_time);
				$date = $dateTimeArr[0];
				$time = $dateTimeArr[1];
				if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$date)) {
				   
				} else {
					$dateArr = explode('-', $date);
					$date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
					//if old date, show error
					if(strtotime($_POST['date_time']) < time()) {
					    $error = 'Do never select an old date and time';
					}
				}		
			} else {
				$error = 'Please select date and time';
			}
		}
	}

	if(isset($_REQUEST['user_id']) && $_REQUEST['user_id']!=''){
		$userId = trim($_REQUEST['user_id']);	
		$userRs = mysqli_query($con, "SELECT * FROM tbl_user WHERE id = '".$userId."'");
		if(mysqli_num_rows($userRs)>0){
			$userRec = mysqli_fetch_array($userRs);
			$defAddress = $userRec['def_address'];
			$phone = $userRec['phone'];
			$hasRes = TRUE;			
			if(isset($_REQUEST['address_id']) && $_REQUEST['address_id']!=''){
				$addressId = trim($_REQUEST['address_id']);	
			} else {
				//check if any additional addresses added. if not select the profile address							
				$additionalAddressRs = mysqli_query($con, "SELECT id FROM tbl_user_address WHERE user_id = '".$userId."'");
				if(mysqli_num_rows($additionalAddressRs)>0){
					$error = 'Please select an address. Click on the address to select';
				} else {
					$addressId = '0';
				}		
			}
			
		} else {
			$error = 'No customer found';
		}	
	} else {
		$error = 'Please select a customer and address';
	}
	
	
	
	if(empty($error)){
		
				
		if($addressId == '0'){
			$userRec = mysqli_fetch_array(mysqli_query($con, "SELECT house_name, street, building_name, place, pin, city, latitude, longitude fROM tbl_user WHERE id = '".$userId."'"));
			$houseName = $userRec['house_name'];
			$street = $userRec['street'];
			$buildingName = $userRec['building_name'];
			$place = $userRec['place'];
			$pin = $userRec['pin'];
			$city = $userRec['city'];
			$latitude = $userRec['latitude'];
			$longitude = $userRec['longitude'];		
				
		} else {
			$addressRec = mysqli_fetch_array(mysqli_query($con, "SELECT * FROM tbl_user_address WHERE user_id = '".$userId."' AND id = '".$addressId."'"));
			$houseName = $addressRec['house_name'];
			$street = $addressRec['street'];
			$buildingName = $addressRec['building_name'];
			$place = $addressRec['place'];
			$pin = $addressRec['pin'];
			$city = $addressRec['city'];
			$latitude = $addressRec['latitude'];
			$longitude = $addressRec['longitude'];	
			
		}
		
		if($latitude!='' && $longitude!=''){
			
			//get tax
			$settingsRec = mysqli_fetch_array(mysqli_query($con, "SELECT tax_percent FROM tbl_settings WHERE id = '1'"));
			$taxPercent = $settingsRec['tax_percent'];
			
			$productRec = mysqli_fetch_array(mysqli_query($con, "SELECT price FROM tbl_products WHERE id = '".$product."'"));
			$unitPrice = $productRec['price'];
			$taxAmount = ($unitPrice*$quantity*$taxPercent)/100;
			
			$totalOrderAmount = ($unitPrice*$quantity)+$taxAmount;
			
			//check if any wallet amount available. If so save it to tbl_job
			//The amount storing should be less than or equel to the total order amount
			$walletAmount = getUserBonus($userId);
			/*$walletRs = mysqli_query($con, "SELECT SUM(amount) AS amount FROM `tbl_user_payments` WHERE `user_id` = '".$userId."'");
			if(mysqli_num_rows($walletRs)>0){
				$walletRec = mysqli_fetch_array($walletRs);
				$walletTotal = $walletRec['amount'];
				$spentRs = mysqli_query($con, "SELECT SUM(`wallet_amount`) AS amount FROM `tbl_technician_payments` WHERE `user_id` = '".$userId."'");
				$spentRec = mysqli_fetch_array($spentRs);
				$spentAmount = $spentRec['amount'];
				//pending
				$spent1Rs = mysqli_query($con, "SELECT SUM(`wallet_amount`) AS amount FROM `tbl_job` WHERE `user_id` = '".$userId."' AND status != 'paid'");
				$spent1Rec = mysqli_fetch_array($spent1Rs);
				$spent1Amount = $spent1Rec['amount'];
				$spentAmount+= $spent1Amount;
				$walletAmount = $walletTotal-$spentAmount;
			}*/
			//wallet amount for this order should not exceed total order amount
			if($walletAmount>$totalOrderAmount){
				$walletAmount = $totalOrderAmount;
			}			
			
			$insertQry = "INSERT INTO tbl_job(user_id, prod_id, address_id, quantity, unit_price, tax_percent, tax_amount, wallet_amount, date, task_date, task_time, now, status, building_name, house_name, street, place, pin, city, latitude, longitude, source, viewed) VALUES (
			 '".mysqli_real_escape_string($con, $userId)."',
			 '".mysqli_real_escape_string($con, $product)."',			 
			 '".$addressId."',	
			 '".mysqli_real_escape_string($con, $quantity)."',
			 '".mysqli_real_escape_string($con, $unitPrice)."',
			 '".mysqli_real_escape_string($con, $taxPercent)."',
			 '".mysqli_real_escape_string($con, $taxAmount)."',
			 '".mysqli_real_escape_string($con, $walletAmount)."',		 
			 '".mysqli_real_escape_string($con, $curDate)."',
			 '".mysqli_real_escape_string($con, $date)."',
			 '".mysqli_real_escape_string($con, $time)."',
			 '".$now."', 
			 'New',
			 '".mysqli_real_escape_string($con, $buildingName)."',
			 '".mysqli_real_escape_string($con, $houseName)."',
			 '".mysqli_real_escape_string($con, $street)."',
			 '".mysqli_real_escape_string($con, $place)."',
			 '".mysqli_real_escape_string($con, $pin)."',
			 '".mysqli_real_escape_string($con, $city)."',
			 '".mysqli_real_escape_string($con, $latitude)."', 
			 '".mysqli_real_escape_string($con, $longitude)."', 'admin', 'yes')";
			 	
			 
			$execInsert = mysqli_query($con,$insertQry);
			$insert_id = mysqli_insert_id($con);		
			
			if($execInsert) {
				$taskId = $insert_id;
				
				if($now=='yes'){
					//auto assign to driver
					$assignRes = autoAssign($taskId);
					  //echo $assignRes; exit;
					if($assignRes!=''){												 
						$assignResArr = explode('-', $assignRes);
						if($assignResArr[0]=='success'){
							$success = $assignResArr[1];
							//update with estimated duration, distance	
							updateDuration($taskId);		
							
													
							header('Location:index.php?page=view_order&id='.$taskId);
							exit();	
						} else {
							$error = $assignResArr[1];
						}
					} else {
						$error = 'Something went wrong';
					}					
				} else {
					header('Location:index.php?page=view_order&id='.$taskId);
					exit();	
				}				
			}
		} else {
			$error = 'The address does not have location(latitude,longitude)';
		}
		
	} else {		
		//if any search results there . show it
		if(isset($_POST['keyword']) && strlen($_POST['keyword'])>0) {
			$keyword = trim($_POST['keyword']);
			if(strlen($keyword)>2){						
				$userRs = mysqli_query($con, "SELECT * FROM tbl_user WHERE (name LIKE '%".$keyword."%' OR phone LIKE '%".$keyword."%' OR email LIKE '%".$keyword."%' OR additional_numbers LIKE '%".$keyword."%') ORDER BY id DESC");
			} else {
				$error = 'Please enter atleast 3 characters';
			}
		}		
		
	}
	
}




?>