<?php
/*
* date last modified 03-10-2017
* Edited by PI-Digi Logical Solutions
* HTML Files - manage_staff.html.php
* Mysql Tables - tbl_admin, tbl_daily_stock, tbl_admin_type
*/
require_once('./classes/class.noseo_pagination.php'); # pagination class
require_once('./includes/functions.php'); # general functions
require_once('./includes/push_functions.php'); # general functions


if(isset($_REQUEST['p']) && $_REQUEST['p']!=''){
	$p = trim($_REQUEST['p']);
} else {
	$p = 1;
}

$driverRs = mysqli_query($con, "SELECT id, name FROM tbl_technician WHERE status = 'Active' ORDER BY name");

$pageVars = '';

// Get All User details to list 
$where = ' id>0 ';
$curTime = date('00:00');
$orderBy = " ORDER BY id DESC ";

if(isset($_POST['clear'])) { ?>
<script language="javascript" type="text/javascript">			
	window.location='index.php?page=<?php echo $page;?>';
</script>
<?php }

if(isset($_GET['action']) && $_GET['action'] == 'delete') {	
	if(isset($_GET['id']) && $_GET['id']!=''){
		$delete = mysqli_query($con,'DELETE FROM tbl_tech_availability_updates WHERE id='.$_GET['id']);
		if($delete) {
			$success = 'Deleted the break';
			?>
	        <script language="javascript" type="text/javascript">			
				window.location='index.php?page=<?php echo $page;?>&success=<?php echo $success; ?>';
			</script>
	        <?php
		}
	}
}
		
/*if(isset($_REQUEST['date']) && strlen(trim($_REQUEST['date'])) > 0) {
	$date = mysqli_real_escape_string($con, trim($_REQUEST['date']));	
	if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$date)) {
		    //ok - yyyy-mm-dd
	} else {
		$dateArr = explode('-', $date);
		$date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
	}
	$where.= " AND date = '".$date."' ";
	$pageVars.= "&date=".$date.'&';	
}	*/

if(isset($_REQUEST['date_to']) && strlen($_REQUEST['date_to'])>0) {
		$to_date = trim($_REQUEST['date_to']);
		if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$to_date)) {
		    //ok - yyy-mm-dd
		} else {
		    $dateArr = explode('-', $to_date);
			$to_date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
		}
} else {
		$to_date = '';
}

if(isset($_REQUEST['from_date']) && strlen($_REQUEST['from_date'])>0) {
		$from_date = trim($_REQUEST['from_date']);
		if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$from_date)) {
		    //ok - yyy-mm-dd
		} else {
		    $dateArr = explode('-', $from_date);
			$from_date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
		}
} else {
		$from_date = '';
}

$curDate = date('Y-m-d');

if($from_date!='' && $to_date!=''){
	$where .= " AND DATE(break_start) BETWEEN '".$from_date."' AND '".$to_date."' ";	
	$pageVars.= '&from_date='.$_REQUEST['from_date'].'&date_to='.$_REQUEST['date_to'].'&';
} else if($from_date!=''){	
	$where .= " AND DATE(break_start) BETWEEN '".$from_date."' AND '".$curDate."' ";
	$pageVars.= '&from_date='.$_REQUEST['from_date'].'&';
} else if($to_date!=''){	
	$where .= " AND DATE(break_start) BETWEEN '".$to_date."' AND '".$curDate."' ";	
	$pageVars.= '&date_to='.$_REQUEST['date_to'].'&';
} 

if(isset($_REQUEST['driver']) && strlen($_REQUEST['driver'])>0) {
	$driverId = trim($_REQUEST['driver']);
	$where.= " AND tech_id = '".$driverId."' ";
	$pageVars.= "&driver=".$driverId.'&';
}


if(isset($_POST['time_from']) && strlen($_POST['time_from'])>0) {		
	$timeFrom = mysqli_real_escape_string($con, trim($_POST['time_from']));
	$timeFrom = str_replace(' ', '', $timeFrom);
	if(isset($_POST['time_to']) && strlen($_POST['time_to'])>0 && $_POST['time_to']!='00 : 00') {		
		$timeTo = mysqli_real_escape_string($con, trim($_POST['time_to']));
		$timeTo = str_replace(' ', '', $timeTo);	
		$where .= " AND TIME(break_start) >= '".$timeFrom."' AND TIME(break_start) <= '".$timeTo."' ";	
		$pageVars.= '&time_from='.$_REQUEST['time_from'].'&time_to='.$_REQUEST['time_to'].'&';
	} else {
		$where .= " AND TIME(break_start) >= '".$timeFrom."' ";	
		$pageVars.= '&time_from='.$_REQUEST['time_from'].'&';
	}
} 


if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='stockid_asc'){
	$orderBy = " ORDER BY daily_stock_id ";
	$pageVars.= 'orderby=stockid_asc&';
} else if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='stockid_dsc'){
	$orderBy = " ORDER BY daily_stock_id DESC ";
	$pageVars.= 'orderby=stockid_dsc&';
} else if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='date_asc'){
	$orderBy = " ORDER BY date ";
	$pageVars.= 'orderby=date_asc&';
} else if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='date_dsc'){
	$orderBy = " ORDER BY date DESC ";
	$pageVars.= 'orderby=date_dsc&';
}


//SELECT * FROM `tbl_tech_availability_updates` WHERE DATE(break_start) = '2019-08-08' AND TIME(break_start)<'16:15:00'


$select = "SELECT id, tech_id, daily_stock_id, date, break_start, TIME(break_start) AS break_start_time, break_end, TIME(break_end) AS break_end_time, last_status FROM tbl_tech_availability_updates WHERE ".$where.$orderBy;

/*if($_SERVER['REMOTE_ADDR']=='202.88.237.77'){	
echo $select;
}*/
// Using pagination class
$pagination = new pagination_noseo($select);
$execDetails = $pagination->createPages(30, $con);

$pageLnk = 'index.php?page='.$page.'&'.$pageVars;
$pageNums = $pagination->pageNumber(5, $pageLnk);

if(isset($_POST['export'])) {
	include '../export/DBController.php';
	$db_handle = new DBController();
	$selectExport = "SELECT id, tech_id, daily_stock_id, date, break_start, TIME(break_start) AS break_start_time, break_end, TIME(break_end) AS break_end_time, last_status FROM tbl_tech_availability_updates WHERE ".$where." ORDER BY id";
	$productResult = $db_handle->runQuery($selectExport);
	
    $filename = "AdLPG-Driver-break-".time().".xls";
    header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"$filename\"");
    $isPrintHeader = false;
	$label = array('0'=>'Stock ID','1'=>'Date','2'=>'Driver','3'=>'Break Start','4'=>'Break End','5'=>'Status');
    if (! empty($productResult)) {    	
        foreach ($productResult as $row) {
        	//$colCount = 0;
            if (! $isPrintHeader) {
                //echo implode("\t", array_keys($row)) . "\n";
				echo implode("\t", $label) . "\n";
                $isPrintHeader = true;				
            } 				
			
			$breakTime = 0;
			$startTime = strtotime($row['break_start']);
			if($row['break_end']!='0000-00-00 00:00:00'){
				$endTime = strtotime($row['break_end']);
			} else {
				$endTime = strtotime(date('Y-m-d H:i:s'));
			}	
			$breakTime = $endTime-$startTime;
			if($breakTime>0){
				$breakTime = $breakTime/60;
				$breakTime = round($breakTime,0);
			}
				 
				//echo $sNo."\t";
				echo '#'.$row['daily_stock_id']."\t";
				echo getFormattedDate($row['date'])."\t";
				echo getDriverName($row['tech_id'])."\t";
				echo getFormattedTime($row['break_start_time'])."\t";				
				if($row['break_end_time']!='00:00:00'){ echo getFormattedTime($row['break_end_time'])."\t";} else { echo 'Not Added'."\t"; };
				if($breakTime>1){					
					echo ucfirst($row['last_status'])." (".$breakTime." Mins.)\t";
				} else {
					echo ucfirst($row['last_status'])."\t";
				}
				
				echo "\n";
				//$sNo++;        
            
        }
    }
    exit();
}

?>