<?php
/*
* date last modified 03-10-2017
* Edited by PI-Digi Logical Solutions
* HTML Files - manage_staff.html.php
* Mysql Tables - tbl_admin, tbl_purchase_order, tbl_admin_type
*/
require_once('./classes/class.noseo_pagination.php'); # pagination class
require_once('./includes/functions.php'); # general functions

if(isset($_REQUEST['p']) && $_REQUEST['p']!=''){
	$p = trim($_REQUEST['p']);
} else {
	$p = 1;
}

if(isset($_POST['clear'])) { ?>
<script language="javascript" type="text/javascript">			
	window.location='index.php?page=<?php echo $page;?>';
</script>
<?php }

$driverRs = mysqli_query($con, "SELECT id, name FROM tbl_technician WHERE status = 'Active'");

$pageVars = '';


$where = ' id > 0 ';

if(isset($_REQUEST['date']) && strlen(trim($_REQUEST['date'])) > 0) {
	$date = mysqli_real_escape_string($con, trim($_REQUEST['date']));	
	if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$date)) {
		    //ok - yyyy-mm-dd
	} else {
		$dateArr = explode('-', $date);
		$date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
	}
	//get total card payments on the date
	$cardPayRs = mysqli_query($con, "SELECT SUM(amount) AS amount FROM `tbl_technician_payments` WHERE `payment_method` = 'Card' AND DATE(date) = '".$date."' AND status = 'paid'");
	$where.= " AND DATE(date) = '".$date."' ";
	$pageVars.= "&date=".$date.'&';	
} else {
	//get total card payments
	$cardPayRs = mysqli_query($con, "SELECT SUM(amount) AS amount FROM `tbl_technician_payments` WHERE `payment_method` = 'Card' AND status = 'paid'");
}

if(isset($_REQUEST['date_to']) && strlen($_REQUEST['date_to'])>0) {
		$to_date = trim($_REQUEST['date_to']);
		if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$to_date)) {
		    //ok - yyy-mm-dd
		} else {
		    $dateArr = explode('-', $to_date);
			$to_date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
		}
} else {
		$to_date = '';
}

if(isset($_REQUEST['from_date']) && strlen($_REQUEST['from_date'])>0) {
		$from_date = trim($_REQUEST['from_date']);
		if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$from_date)) {
		    //ok - yyy-mm-dd
		} else {
		    $dateArr = explode('-', $from_date);
			$from_date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
		}
} else {
		$from_date = '';
}

if($from_date!='' && $to_date!=''){
	$where .= " AND DATE(date) BETWEEN '".$from_date."' AND '".$to_date."' ";	
	$pageVars.= '&from_date='.$_REQUEST['from_date'].'&date_to='.$_REQUEST['date_to'].'&';
}


if(isset($_REQUEST['driver']) && strlen($_REQUEST['driver'])>0) {
	$driverId = trim($_REQUEST['driver']);
	$where.= " AND technician_id = '".$driverId."' ";
	$pageVars.= "&driver=".$driverId.'&';
}

if(mysqli_num_rows($cardPayRs)>0){
	$cardPayRec = mysqli_fetch_array($cardPayRs);
	if($cardPayRec['amount']!='' && strlen($cardPayRec['amount'])>0){
		$totalCardAmount = $cardPayRec['amount'];
	} else {
		$totalCardAmount = '0.00';
	}
} else {
	$totalCardAmount = '0.00';
}

$orderBy=" ORDER BY id DESC";
if(isset($_REQUEST['order']) && $_REQUEST['order']=='date_asc'){
	$orderBy = " ORDER BY date ASC ";
	$pageVars .=  "&order=date_asc&"; 
} else if(isset($_REQUEST['order']) && $_REQUEST['order']=='date_dsc'){
	$orderBy = " ORDER BY date DESC ";
	$pageVars .=  "&order=date_dsc&"; 
} elseif(isset($_REQUEST['order']) && $_REQUEST['order']=='stockid_asc') {
	$orderBy = " ORDER BY daily_stock_id ASC ";
	$pageVars .=  "&order=stockid_asc&"; 
} elseif(isset($_REQUEST['order']) && $_REQUEST['order']=='stockid_dsc') {
	$orderBy = " ORDER BY daily_stock_id DESC ";
	$pageVars .=  "&order=stockid_dsc&"; 
}

$select = "SELECT * FROM tbl_admin_tech_incomes WHERE ".$where.$orderBy;
//echo $select;
// Using pagination class
$pagination = new pagination_noseo($select);
$execDetails = $pagination->createPages(30, $con);

$pageLnk = 'index.php?page='.$page.'&'.$pageVars;
$pageNums = $pagination->pageNumber(5, $pageLnk);


if(isset($_POST['export'])) {
	include '../export/DBController.php';
	$db_handle = new DBController();	
	$productResult = $db_handle->runQuery("SELECT * FROM tbl_admin_tech_incomes WHERE ".$where.$orderBy);
		
    $filename = "AdLPG-Driver-Payments-".time().".xls";
    header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"$filename\"");
    $isPrintHeader = false;
	$label = array('0'=>'Stock ID','1'=>'Name','2'=>'Cash Payment','3'=>'Card Payment','4'=>'Date & Time','5'=>'Added By');
    if (! empty($productResult)) {
        foreach ($productResult as $row) {
        	//$colCount = 0;
            if (! $isPrintHeader) {
                //echo implode("\t", array_keys($row)) . "\n";
				echo implode("\t", $label) . "\n";
                $isPrintHeader = true;				
            } 				
			
 				$cardAmount = getDriverCardDaily($row['technician_id'], $row['daily_stock_id']);
				
				echo '#'.$row['daily_stock_id']."\t";
				echo getDriverName($row['technician_id'])."\t";
				echo $row['amount']."\t";
				echo $cardAmount."\t";				
				echo getFormattedDateTime($row['date'])."\t";
				echo getAdminUserName($row['added_by'])."\t";	
				echo "\n";
				//$colCount++;        
            
        }
    }
    exit();
}

?>