<?php
/*
* date last modified 28-11-2017
* Edited by PI-Digi Logical Solutions
* HTML Files - add_user.html.php
* Mysql Tables - tbl_designation, tbl_user
*/
include('includes/functions.php'); # general functions
include('includes/sms_function.php'); 

function generatePassword($length = 6) {
    $characters = 'abcdefghijklmnopqrstuvwxyz';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}

$debug = false;
$isEdit = FALSE;

//get products
$productRs = mysqli_query($con, "SELECT id, name FROM tbl_products");
$driverRs = mysqli_query($con, "SELECT DISTINCT driver FROM `tbl_job_history` WHERE driver!='' ORDER BY driver");


if(isset($_REQUEST['id']) && $_REQUEST['id']!=''){

	$isEdit = TRUE;
	$editId = mysqli_real_escape_string($con, trim($_REQUEST['id']));
	$resEdit = mysqli_fetch_array(mysqli_query($con, "SELECT * FROM tbl_job_history WHERE id = '".$editId."'"));
	$userId = $resEdit['user_id'];
	$taskDate = $resEdit['task_date'];
	$dateArr = explode('-', $taskDate);
	$taskDate = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
	$unitPrice = $resEdit['unit_price'];
	$quantity = $resEdit['quantity'];
	$taxAmount = $resEdit['tax_amount'];
	$totalAmount = ($unitPrice*$quantity)+$taxAmount;
}



if(isset($_POST['update'])) {
	
	if(strlen(trim($_POST['task_date'])) > 0) {
		$taskDate = trim($_POST['task_date']);
		if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$taskDate)) {
		    //ok - yyyy-mm-dd
		} else {
		    $dateArr = explode('-', $taskDate);
			$taskDate = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
		}
	} else {
		$error = 'Please select order date';		
	}
	
	if(isset($_POST['quantity']) && $_POST['quantity']!=''){
		$quantity = trim($_POST['quantity']);
	} else {
		$error = 'Please select quantity';
	}
	
	if(isset($_POST['product']) && $_POST['product']!=''){
		$product = trim($_POST['product']);
	} else {
		$error = 'Please select a product';
	}
	
	if(isset($_POST['driver']) && $_POST['driver']!=''){
		$driver = trim($_POST['driver']);
	} else {
		$error = 'Please enter driver name';
	}

	if(empty($error)) {
		
		//find tottal price				
		$prodRec = mysqli_fetch_array(mysqli_query($con, "SELECT price FROM tbl_products WHERE id = '".$product."'"));
		$prodPrice = $prodRec['price'];
		$settingsRec = mysqli_fetch_array(mysqli_query($con, "SELECT tax_percent FROM tbl_settings WHERE id = '1'"));
		$taxPercent = $settingsRec['tax_percent'];
		$total = $prodPrice*$quantity;
		$taxAmount = ($total*$taxPercent)/100;
		$totalAmount = $total+$taxAmount;		
		
				
		$execUpdate = mysqli_query($con, "UPDATE tbl_job_history SET driver = '".$driver."', prod_id = '".$product."', quantity = '".$quantity."', 
		unit_price = '".$prodPrice."', tax_percent = '".$taxPercent."', tax_amount = '".$taxAmount."', date = '".$taskDate."', 
		task_date = '".$taskDate."' WHERE id = '".$editId."'");
		
		
			if($execUpdate) {
				$success = 'The order has been updated successfully';
				header('Location:index.php?page=edit_order&id='.$editId.'&success='.$success);
				exit();
			} else {
				$error = 'Unable to update order';
			}
		
	}
}
?>