<?php
/*
* date last modified 03-10-2017
* Edited by PI-Digi Logical Solutions
* HTML Files - manage_staff.html.php
* Mysql Tables - tbl_admin, tbl_daily_stock, tbl_admin_type
*/
require_once('./classes/class.noseo_pagination.php'); # pagination class
require_once('./includes/functions.php'); # general functions

if(isset($_REQUEST['p']) && $_REQUEST['p']!=''){
	$p = trim($_REQUEST['p']);
} else {
	$p = 1;
}

$helperRs = mysqli_query($con, "SELECT id, name FROM tbl_helper WHERE status = 'Active'");
$driverRs = mysqli_query($con, "SELECT id, name FROM tbl_technician WHERE status = 'Active'");


$pageVars = '';

// Get All User details to list 
$where = ' id > 0 ';

if(isset($_POST['clear'])) { ?>
<script language="javascript" type="text/javascript">			
	window.location='index.php?page=<?php echo $page;?>';
</script>
<?php }
		
if(isset($_REQUEST['date']) && strlen(trim($_REQUEST['date'])) > 0) {
	$date = mysqli_real_escape_string($con, trim($_REQUEST['date']));	
	if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$date)) {
		    //ok - yyyy-mm-dd
	} else {
		$dateArr = explode('-', $date);
		$date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
	}
	$where.= " AND DATE(date) = '".$date."' ";
	$pageVars.= "&date=".$date.'&';	
}	

if(isset($_REQUEST['helper']) && strlen($_REQUEST['helper'])>0) {
	$helperId = trim($_REQUEST['helper']);
	$where.= " AND helper_id = '".$helperId."' ";
	$pageVars.= "&helper=".$helperId.'&';
}

if(isset($_REQUEST['driver']) && strlen($_REQUEST['driver'])>0) {
	$driverId = trim($_REQUEST['driver']);
	$where.= " AND driver_id = '".$driverId."' ";
	$pageVars.= "&driver=".$driverId.'&';
}

if(isset($_REQUEST['date_to']) && strlen($_REQUEST['date_to'])>0) {
		$to_date = trim($_REQUEST['date_to']);
		if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$to_date)) {
		    //ok - yyy-mm-dd
		} else {
		    $dateArr = explode('-', $to_date);
			$to_date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
		}
} else {
		$to_date = '';
}

if(isset($_REQUEST['from_date']) && strlen($_REQUEST['from_date'])>0) {
		$from_date = trim($_REQUEST['from_date']);
		if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$from_date)) {
		    //ok - yyy-mm-dd
		} else {
		    $dateArr = explode('-', $from_date);
			$from_date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
		}
} else {
		$from_date = '';
}

if($from_date!='' && $to_date!=''){
	$where .= " AND DATE(date) BETWEEN '".$from_date."' AND '".$to_date."' ";	
	$pageVars.= '&from_date='.$_REQUEST['from_date'].'&date_to='.$_REQUEST['date_to'].'&';
}

$orderBy=" ORDER BY id DESC";
if(isset($_REQUEST['order']) && $_REQUEST['order']=='date_asc'){
	$orderBy = " ORDER BY date ASC ";
	$pageVars .=  "&order=date_asc&"; 
} else if(isset($_REQUEST['order']) && $_REQUEST['order']=='date_dsc'){
	$orderBy = " ORDER BY date DESC ";
	$pageVars .=  "&order=date_dsc&"; 
} elseif(isset($_REQUEST['order']) && $_REQUEST['order']=='stockid_asc') {
	$orderBy = " ORDER BY daily_stock_id ASC ";
	$pageVars .=  "&order=stockid_asc&"; 
} elseif(isset($_REQUEST['order']) && $_REQUEST['order']=='stockid_dsc') {
	$orderBy = " ORDER BY daily_stock_id DESC ";
	$pageVars .=  "&order=stockid_dsc&"; 
}

$select = "SELECT * FROM tbl_incentives WHERE ".$where.$orderBy;

/*if($_SERVER['REMOTE_ADDR']=='202.88.237.77'){
echo $select;
}*/
// Using pagination class
$pagination = new pagination_noseo($select);
$execDetails = $pagination->createPages(30, $con);

$pageLnk = 'index.php?page='.$page.'&'.$pageVars;
$pageNums = $pagination->pageNumber(5, $pageLnk);

if(isset($_POST['export'])) {
	include '../export/DBController.php';
	$db_handle = new DBController();	
	$productResult = $db_handle->runQuery("SELECT * FROM tbl_incentives WHERE ".$where.$orderBy);
	
	if($_SERVER['REMOTE_ADDR']=='202.88.237.77'){
		$filename = "AdLPG-Incentives-Report-".time().".xlsx";    	
    	//header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    	//header("Content-Disposition: attachment; filename=\"$filename\"");
    	    	
		header('Content-Disposition: attachment; filename=' . $filename );
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		//header('Content-Length: ' . filesize($filename));
		header('Content-Transfer-Encoding: binary');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		//readfile($filename);
	} else {
		$filename = "AdLPG-Incentives-Report-".time().".xls";
    	header("Content-Type: application/vnd.ms-excel");
   		header("Content-Disposition: attachment; filename=\"$filename\"");
	}
    
    $isPrintHeader = false;
	$label = array('0'=>'Stock ID','1'=>'Date','2'=>'Driver','3'=>'Helper','4'=>'Sold Count','5'=>'Total','6'=>'Driver Commission');
    if (! empty($productResult)) {
        foreach ($productResult as $row) {
        	//$colCount = 0;
            if (! $isPrintHeader) {
                //echo implode("\t", array_keys($row)) . "\n";
				echo implode("\t", $label) . "\n";
                $isPrintHeader = true;				
            } 				
			
			$soldCount = $row['sold_count'];
			$incentives = $row['amount']*2;
				 
				echo '#'.$row['daily_stock_id']."\t";
				echo getFormattedDate($row['date'])."\t";
				echo getDriverName($row['driver_id'])."\t";
					
				echo $soldCount."\t";
				echo number_format((float)$incentives, 2, '.', '')."\t";
				echo number_format((float)$row['amount'], 2, '.', '')."\t";
				
				echo "\n";
				//$colCount++;        
            
        }
    }
    exit();
}
?>