<?php
/*
* date last modified 03-10-2017
* Edited by PI-Digi Logical Solutions
* HTML Files - manage_staff.html.php
* Mysql Tables - tbl_admin, tbl_daily_stock, tbl_admin_type
*/
require_once('./classes/class.noseo_pagination.php'); # pagination class
require_once('./includes/functions.php'); # general functions
require_once('./includes/push_functions.php'); # general functions


if(isset($_REQUEST['p']) && $_REQUEST['p']!=''){
	$p = trim($_REQUEST['p']);
} else {
	$p = 1;
}


if(isset($_POST['clear'])) { ?>
<script language="javascript" type="text/javascript">			
	window.location='index.php?page=<?php echo $page;?>&clear=yes';
</script>
<?php }

$vehicleRs = mysqli_query($con, "SELECT id, number FROM tbl_vehicle WHERE status = 'Active'");
$driverRs = mysqli_query($con, "SELECT id, name FROM tbl_technician WHERE status = 'Active'");


if(isset($_GET['action']) && $_GET['action'] == 'delete') {
	/* Delete User */
	if(isset($_GET['del_id']) && $_GET['del_id']!=''){
		$delId = trim($_GET['del_id']);		
		//delete incentives if any
		mysqli_query($con, "DELETE FROM tbl_incentives WHERE daily_stock_id = '".$delId."'"); 
		$delete = mysqli_query($con,"DELETE FROM tbl_daily_stock WHERE id='".$_GET['del_id']."'");
		if($delete) {
			$success = 'Deleted the stock record';
			?>
	        <script language="javascript" type="text/javascript">			
				window.location='index.php?page=<?php echo $page;?>&p=<?php echo $p;?>&success=<?php echo $success; ?>';
			</script>
	        <?php
		}
	}
}

$pageVars = '';

// Get All User details to list 
$where = ' id>0 ';

		
if(isset($_REQUEST['date']) && strlen(trim($_REQUEST['date'])) > 0) {
	$date = mysqli_real_escape_string($con, trim($_REQUEST['date']));	
	if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$date)) {
		    //ok - yyyy-mm-dd
	} else {
		$dateArr = explode('-', $date);
		$date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
	}
	$where.= " AND date = '".$date."' ";
	$pageVars.= "&date=".$date.'&';	
}	

if(isset($_REQUEST['vehicle']) && strlen($_REQUEST['vehicle'])>0) {
	$vehicleId = trim($_REQUEST['vehicle']);
	$where.= " AND vehicle_id = '".$vehicleId."' ";
	$pageVars.= "&vehicle=".$vehicleId.'&';
}

if(isset($_REQUEST['driver']) && strlen($_REQUEST['driver'])>0) {
	$driverId = trim($_REQUEST['driver']);
	$where.= " AND driver_id = '".$driverId."' ";
	$pageVars.= "&driver=".$driverId.'&';
}

if(isset($_REQUEST['status']) && strlen($_REQUEST['status'])>0) {
	$stat = trim($_REQUEST['status']);
	if($stat=='open'){
		$where.= " AND closed = 'no' ";
	} else if($stat=='closed'){
		$where.= " AND closed = 'yes' ";
	}	
	$pageVars.= "&status=".$stat.'&';
}

if(isset($_REQUEST['date_to']) && strlen($_REQUEST['date_to'])>0) {
		$to_date_req = trim($_REQUEST['date_to']);
		if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$to_date_req)) {
		    //ok - yyy-mm-dd
		    $to_date = $to_date_req;
		} else {
		    $dateArr = explode('-', $to_date_req);
			$to_date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
		}
} else {
		
		if(!isset($_REQUEST['clear'])){
			$to_date = date('Y-m-d');
			$to_date_req = date('d-m-Y');
		} else {
			$to_date = '';
			$to_date_req = '';
		}
		
}

if(isset($_REQUEST['from_date']) && strlen($_REQUEST['from_date'])>0) {
		$from_date_req = trim($_REQUEST['from_date']);
		if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$from_date_req)) {
		    //ok - yyy-mm-dd
		    $from_date = $from_date_req;
		} else {
		    $dateArr = explode('-', $from_date_req);
			$from_date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
		}
} else {			
		if(!isset($_REQUEST['clear'])){
			$from_date_req = date('d-m-Y');
			$from_date = date('Y-m-d');	
		} else {
			$from_date = '';	
			$from_date_req = '';
		}
}

$curDate = date('Y-m-d');


if($from_date!='' && $to_date!=''){
	$where .= " AND date BETWEEN '".$from_date."' AND '".$to_date."' ";	
	$pageVars.= '&from_date='.$from_date_req.'&date_to='.$to_date_req.'&';
} else if($from_date!=''){	
	$where .= " AND date BETWEEN '".$from_date."' AND '".$curDate."' ";	
	$pageVars.= '&from_date='.$from_date_req.'&';
} else if($to_date!=''){	
	$where .= " AND date BETWEEN '".$to_date."' AND '".$curDate."' ";	
	$pageVars.= '&date_to='.$to_date_req.'&';
}

$orderBy=" ORDER BY id DESC";
if(isset($_REQUEST['order']) && $_REQUEST['order']=='date_asc'){
	$orderBy = " ORDER BY date ASC,opening_time ASC ";
	$pageVars .=  "&order=date_asc&"; 
} else if(isset($_REQUEST['order']) && $_REQUEST['order']=='date_dsc'){
	$orderBy = " ORDER BY date DESC,opening_time DESC ";
	$pageVars .=  "&order=date_dsc&"; 
}

if((isset($_REQUEST['clear']) && $_REQUEST['clear']=='yes') && (!isset($_POST['submit1']) && !isset($_POST['export']))) {	
	$pageVars = '&clear=yes&';
	//$from_date_req = $to_date_req = '';
	$select = "SELECT * FROM tbl_daily_stock ".$orderBy;
} else {
	if(($from_date == date('Y-m-d')) && ($to_date == date('Y-m-d'))){
		if(!isset($_POST['submit1']) && !isset($_POST['export'])){
			$select = "SELECT * FROM tbl_daily_stock WHERE ".$where." OR (closed = 'no') ".$orderBy;
		} else {
			$select = "SELECT * FROM tbl_daily_stock WHERE ".$where.$orderBy;
		}
		//$select = "SELECT * FROM tbl_daily_stock WHERE ".$where." OR (closed = 'no') ".$orderBy;
	} else {
		$select = "SELECT * FROM tbl_daily_stock WHERE ".$where.$orderBy;
	}
}

/*if($_SERVER['REMOTE_ADDR']=='202.88.237.77'){
echo $select;
}*/
// Using pagination class
$pagination = new pagination_noseo($select);
$execDetails = $pagination->createPages(30, $con);

$pageLnk = 'index.php?page='.$page.'&'.$pageVars;
$pageNums = $pagination->pageNumber(5, $pageLnk);


if(isset($_POST['export'])) {
	include '../export/DBController.php';
	$db_handle = new DBController();	
	$productResult = $db_handle->runQuery("SELECT * FROM tbl_daily_stock WHERE ".$where.$orderBy);
	
    $filename = "OnDemandPro-Daily-Stock-".time().".xls";
    header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"$filename\"");
    $isPrintHeader = false;
	$label = array('0'=>'Stock ID','1'=>'Date','2'=>'Time','3'=>'Vehicle','4'=>'Driver','5'=>'Opening Stock','6'=>'Closing Stock','7'=>'Pending Orders','8'=>'Status');
    if (! empty($productResult)) {
        foreach ($productResult as $row) {
        	//$colCount = 0;
            if (! $isPrintHeader) {
                //echo implode("\t", array_keys($row)) . "\n";
				echo implode("\t", $label) . "\n";
                $isPrintHeader = true;				
            } 				
			
			$totalSoldCount = 0;								
			$dialyProductRs = mysqli_query($con, "SELECT SUM(opening_stock) AS opening_stock, SUM(closing_stock) AS closing_stock FROM tbl_daily_stock_products WHERE daily_stock_id = '".$row['id']."'");
			if(mysqli_num_rows($dialyProductRs)>0){
				$dialyProductRec = mysqli_fetch_array($dialyProductRs);
				$openingStock = $dialyProductRec['opening_stock'];
				$clossingStock = $dialyProductRec['closing_stock'];
				if(strlen($clossingStock)>0){
					$totalSoldCount = $openingStock-$clossingStock;														
				} else {
					$openingStock = $row['opening_stock'];
					$clossingStock = $row['closing_stock'];	
					$totalSoldCount = $openingStock-$clossingStock;													
				}
			} else {
				//old logic
				$clossingStock = $row['closing_stock'];
			}	
							 
				echo '#'.$row['id']."\t";
				echo getFormattedDate($row['date'])."\t";
				echo getFormattedTime($row['opening_time'])."\t";
				echo getVehicleNumber($row['vehicle_id'])."\t";				
				echo getDriverName($row['driver_id'])."\t";
				//echo getHelperName($row['helper_id'])."\t";
				
				//find opening stock
				$prodIdRs = mysqli_query($con, "SELECT DISTINCT prod_id FROM tbl_daily_stock_products WHERE daily_stock_id = '".$row['id']."'");
				while($prodIdRec= mysqli_fetch_array($prodIdRs)){
					$prodId = $prodIdRec['prod_id'];
					$prodStockRec = mysqli_fetch_array(mysqli_query($con, "SELECT opening_stock FROM tbl_daily_stock_products WHERE prod_id = '".$prodId."' AND daily_stock_id = '".$row['id']."'"));
					$prodOpeningStock = $prodStockRec['opening_stock'];
					echo getProductName($prodId).': '.$prodOpeningStock.', ';															
				}
				echo "\t";
				
				//find closing stock
				if($row['closed']=='yes'){
                	//echo $clossingStock; 
                    $prodIdRs = mysqli_query($con, "SELECT DISTINCT prod_id FROM tbl_daily_stock_products WHERE daily_stock_id = '".$row['id']."'");
					while($prodIdRec= mysqli_fetch_array($prodIdRs)){
						$prodId = $prodIdRec['prod_id'];
						$prodCloseStockRec = mysqli_fetch_array(mysqli_query($con, "SELECT closing_stock FROM tbl_daily_stock_products WHERE prod_id = '".$prodId."' AND daily_stock_id = '".$row['id']."'"));
						$prodClosingStock = $prodCloseStockRec['closing_stock'];
						echo getProductName($prodId).': '.$prodClosingStock.', ';															
					}																									
				} else {
					$activeDriverId = $row['driver_id'];
					$stockId = $row['id'];													
					$prodIdRs = mysqli_query($con, "SELECT DISTINCT prod_id FROM tbl_daily_stock_products WHERE daily_stock_id = '".$stockId."'");
						while($prodIdRec= mysqli_fetch_array($prodIdRs)){
							$prodId = $prodIdRec['prod_id'];
							$prodStockRec = mysqli_fetch_array(mysqli_query($con, "SELECT opening_stock FROM tbl_daily_stock_products WHERE prod_id = '".$prodId."' AND daily_stock_id = '".$stockId."'"));
							$prodOpeningStock = $prodStockRec['opening_stock'];
							$pendingQuantity = 0;
							$soldQuantity = 0;
							//get current live stock available
							//get total quantity pending
							$pendingOrderRs = mysqli_query($con, "SELECT SUM(quantity) AS quantity FROM tbl_job WHERE technician_id = '".$activeDriverId."' AND prod_id = '".$prodId."' AND (status = 'assigned' OR status = 'start_off' OR status = 'arrived' OR status = 'completed')");
							if(mysqli_num_rows($pendingOrderRs)>0){
								$pendingOrderRec = mysqli_fetch_array($pendingOrderRs);
								if($pendingOrderRec['quantity']!='' && strlen($pendingOrderRec['quantity'])>0){
									$pendingQuantity = $pendingOrderRec['quantity'];
								} else {
									$pendingQuantity = 0;
								}								
							}
							//get total sold quantity
							$soldOrderRs = mysqli_query($con, "SELECT SUM(quantity) AS quantity FROM tbl_job WHERE technician_id = '".$activeDriverId."' AND daily_stock_id = '".$stockId."' AND prod_id = '".$prodId."' AND status = 'paid'");
							if(mysqli_num_rows($soldOrderRs)>0){
								$soldOrderRec = mysqli_fetch_array($soldOrderRs);
								if($soldOrderRec['quantity']!='' && strlen($soldOrderRec['quantity'])>0){
									$soldQuantity = $soldOrderRec['quantity'];
								} else {
									$soldQuantity = 0;
								}								
							}
							//echo 'opening-'.$prodOpeningStock.', pending-'.$pendingQuantity.', sold-'.$soldQuantity;
							$currentStock = $prodOpeningStock-($pendingQuantity+$soldQuantity);
							
							$prodLiveStockRec = mysqli_fetch_array(mysqli_query($con, "SELECT closing_stock FROM tbl_daily_stock_products WHERE prod_id = '".$prodId."' AND daily_stock_id = '".$row['id']."'"));
							$prodClosingStock = $currentStock;
								echo getProductName($prodId).': '.$prodClosingStock.', ';															
							}
				}				 				
				echo "\t";
				
				//get pending order count with this driver
				if($row['closed']=='no'){
					$pendingRs = mysqli_query($con, "SELECT count(id) AS count FROM tbl_job WHERE technician_id = '".$activeDriverId."' AND (status = 'assigned' OR status = 'start_off' OR status = 'arrived' OR status = 'completed')");
					if(mysqli_num_rows($pendingRs)>0){
						$pendingRec = mysqli_fetch_array($pendingRs);
						if($pendingRec['count']!='' && strlen($pendingRec['count'])>0){
							$pendingOrders = $pendingRec['count'];
						} else {
							$pendingOrders = 0;
						}								
					}
					if($pendingOrders>0){ 
						echo $pendingOrders;
					} else { echo $pendingOrders; }														
				}
				echo "\t";
				if($row['closed']=='yes'){ echo 'Closed'; } else { echo 'Open'; } echo "\t";				
				echo "\n";
					//$colCount++;        
            
        }
    }
    exit();
}

?>