<?php
/*
* date last modified 28-11-2017
* Edited by PI-Digi Logical Solutions
* HTML Files - add_user.html.php
* Mysql Tables - tbl_technician, tbl_helper, tbl_vehicle, tbl_daily_stock
*/
include('includes/functions.php'); # general functions
include('includes/push_functions.php'); 


$isEdit = FALSE;
$latitude = $longitude = '';
$curDate = date('Y-m-d H:i:s');		
$curTime = date('H:i:s');

$driverRs = mysqli_query($con, "SELECT id, name FROM tbl_technician WHERE status = 'Active'");
$vehicleRs = mysqli_query($con, "SELECT id, number FROM tbl_vehicle WHERE status = 'Active'");
$helperRs = mysqli_query($con, "SELECT id, name FROM tbl_helper WHERE status = 'Active'");
$warehouseRs = mysqli_query($con, "SELECT id, name FROM tbl_warehouse");

//get drivers, vehicles and helpers who already assigned to stock
$liveDriverArray = array();
$liveVehicleArray = array();
$liveHelperArray = array();
$liveDriverRs = mysqli_query($con, "SELECT id FROM tbl_technician WHERE id IN (SELECT driver_id FROM tbl_daily_stock WHERE closed = 'no')");
if(mysqli_num_rows($liveDriverRs)){
	while($liveDriverRec = mysqli_fetch_array($liveDriverRs)){
		$liveDriverArray[] = $liveDriverRec['id'];
	}
}
$liveHelperRs = mysqli_query($con, "SELECT id FROM tbl_helper WHERE id IN (SELECT helper_id FROM tbl_daily_stock WHERE closed = 'no')");
if(mysqli_num_rows($liveHelperRs)){
	while($liveHelperRec = mysqli_fetch_array($liveHelperRs)){
		$liveHelperArray[] = $liveHelperRec['id'];
	}
}
$liveVehicleRs = mysqli_query($con, "SELECT id FROM tbl_vehicle WHERE id IN (SELECT vehicle_id FROM tbl_daily_stock WHERE closed = 'no')");
if(mysqli_num_rows($liveVehicleRs)){
	while($liveVehicleRec = mysqli_fetch_array($liveVehicleRs)){
		$liveVehicleArray[] = $liveVehicleRec['id'];
	}
}

if(isset($_REQUEST['id']) && $_REQUEST['id']!=''){
	
	$isEdit = TRUE;
	$editId = mysqli_real_escape_string($con, trim($_REQUEST['id']));
			
	$editRs = mysqli_query($con, "SELECT * FROM tbl_daily_stock WHERE id = '".$editId."'");
	if(mysqli_num_rows($editRs)>0){
		$resEdit = mysqli_fetch_array($editRs);
		$warehouseId = $resEdit['warehouse_id'];
		$driverId = $resEdit['driver_id'];
		$vehicleId = $resEdit['vehicle_id'];
		$helperId = $resEdit['helper_id'];
		$curTime = $resEdit['opening_time'];
		
		$dateArr = explode('-',$resEdit['date']);
		$date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
		
		
	} else {
		$error = 'Helper does not exist!';
	}

} 

if(isset($_POST['add'])) {
					
	if(isset($_POST['opening_time']) && strlen($_POST['opening_time'])>0) {		
		$openingTime = mysqli_real_escape_string($con, trim($_POST['opening_time']));
		$curTime = $openingTime;
		$openingTime = str_replace(' ', '', $openingTime);
	} else {
		$error = 'Please select opening time';
	}
	
		
	/*if(isset($_POST['opening_stock']) && strlen($_POST['opening_stock'])>0) {
		$openingStock = mysqli_real_escape_string($con, trim($_POST['opening_stock']));
		if(is_numeric($openingStock)){
			if($openingStock>0 && $openingStock<1000){
				//ok
			} else {
				$error = 'The opening stock should be between 0 and 1000';
			}
		} else {
			$error = 'Enter a numeric value for opening stock';
		}
	} else {
		$error = 'Please enter opening stock';
	}*/
	
	$productRs = mysqli_query($con, "SELECT id, name FROM tbl_products WHERE status = 'Active'");
	if(mysqli_num_rows($productRs)>0){
		$submitProds = array();
		while($productRec = mysqli_fetch_array($productRs)){
			if(isset($_POST['opening_stock'.$productRec['id']]) && $_POST['opening_stock'.$productRec['id']]!=''){
				$openingStock = $_POST['opening_stock'.$productRec['id']];
				if(is_numeric($openingStock)){
					if($openingStock>=0 && $openingStock<1000){
						$submitProds[$productRec['id']] = $openingStock;
					} else {
						$error = 'The opening stock should be between 0 and 1000';
					}
				} else {
					$error = 'Enter a numeric value for opening stock of '.$productRec['name'];
				}				
			} else {
				$error = 'Enter opening stock of '.$productRec['name'];
			}
		}
	}

	if(isset($_POST['helper']) && strlen($_POST['helper'])>0) {
		$helperId = mysqli_real_escape_string($con, trim($_POST['helper']));
	} else {
		$helperId = "";
		//$error = 'Please select a helper';
	}

	if(isset($_POST['vehicle']) && strlen($_POST['vehicle'])>0) {
		$vehicleId = mysqli_real_escape_string($con, trim($_POST['vehicle']));
	} else {
		$error = 'Please select a vehicle';
	}
	
	if(isset($_POST['driver']) && strlen($_POST['driver'])>0) {
		$driverId = mysqli_real_escape_string($con, trim($_POST['driver']));
	} else {
		$error = 'Please select a driver';
	}

	if(isset($_POST['warehouse']) && strlen($_POST['warehouse'])>0) {
		$warehouseId = mysqli_real_escape_string($con, trim($_POST['warehouse']));
	} else {
		$error = 'Please select warehouse';
	}		
	
	if(isset($_POST['shift']) && strlen($_POST['shift'])>0) {
		$shift = mysqli_real_escape_string($con, trim($_POST['shift']));		
	} else {
		$error = 'Please select shift';
	}
	
	if(strlen(trim($_POST['date'])) > 0) {
		$date = mysqli_real_escape_string($con, trim($_POST['date']));	
		if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$date)) {
		    //ok - yyyy-mm-dd
		} else {
		    $dateArr = explode('-', $date);
			$date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
		}	
	} else {
		$error = 'Please select date';
	}
	
	if(empty($error)) {
		
		//check if the same helper is still in a live vehicle
		//$chkHelpRs = mysqli_query($con, "SELECT id FROM tbl_daily_stock WHERE date = '".$date."' AND helper_id = '".$helperId."' AND shift = '".$shift."'");
		$chkHelpRs = mysqli_query($con, "SELECT id FROM tbl_daily_stock WHERE helper_id = '".$helperId."' AND closed = 'no'");
		if(mysqli_num_rows($chkHelpRs)>0){
			$error = 'Sorry, this helper already added for the same date with shift '.$shift;
		} else {
			//if shift2 is selected check if shift1 with same helper (if exists) closed. If not closed, show error
			if($shift=='shift2'){
				$chkShiftRs = mysqli_query($con, "SELECT closed FROM tbl_daily_stock WHERE date = '".$date."' AND helper_id = '".$helperId."' AND shift = 'shift1'");
				if(mysqli_num_rows($chkShiftRs)>0){
					$chkShiftRec = mysqli_fetch_array($chkShiftRs);
					if($chkShiftRec['closed']=='yes'){
						//ok
					} else {
						$error = 'Sorry. You should close Shift1 with this helper for the selected date';
					}
				} else {
					//shift1 not added with this helper. so its ok here
				}
			}
			//if shift1 is selected check if shift2 with same helper (if exists) closed. If not closed, show error
			if($shift=='shift1'){
				//$chkShiftRs = mysqli_query($con, "SELECT closed FROM tbl_daily_stock WHERE date = '".$date."' AND helper_id = '".$helperId."' AND shift = 'shift2'");
				$chkShiftRs = mysqli_query($con, "SELECT closed FROM tbl_daily_stock WHERE helper_id = '".$helperId."' AND shift = 'shift2'");
				if(mysqli_num_rows($chkShiftRs)>0){
					$chkShiftRec = mysqli_fetch_array($chkShiftRs);
					if($chkShiftRec['closed']=='yes'){
						//ok
					} else {
						$error = 'Sorry. You should close Shift2 with this helper for the selected date';
					}
				} else {
					//shift2 not added with this helper. so its ok here
				}
			}
		}
		
		//check if the same vehicle already added on same date
		//$chkVehRs = mysqli_query($con, "SELECT id FROM tbl_daily_stock WHERE date = '".$date."' AND vehicle_id = '".$vehicleId."' AND shift = '".$shift."'");
		$chkVehRs = mysqli_query($con, "SELECT id FROM tbl_daily_stock WHERE vehicle_id = '".$vehicleId."' AND closed = 'no'");
		if(mysqli_num_rows($chkVehRs)>0){
			$error = 'Sorry, this vehicle is already live';
		} else {
			//if shift2 is selected check if shift1 with same vehicle (if exists) closed. If not closed, show error
			/*if($shift=='shift2'){
				$chkShiftRs = mysqli_query($con, "SELECT closed FROM tbl_daily_stock WHERE date = '".$date."' AND vehicle_id = '".$vehicleId."' AND shift = 'shift1'");
				if(mysqli_num_rows($chkShiftRs)>0){
					$chkShiftRec = mysqli_fetch_array($chkShiftRs);
					if($chkShiftRec['closed']=='yes'){
						//ok
					} else {
						$error = 'Sorry. You should close Shift1 with this vehicle for the selected date';
					}
				} else {
					//shift1 not added with this vehicle. so its ok here
				}
			}
			//if shift1 is selected check if shift2 with same vehicle (if exists) closed. If not closed, show error
			if($shift=='shift1'){
				$chkShiftRs = mysqli_query($con, "SELECT closed FROM tbl_daily_stock WHERE date = '".$date."' AND vehicle_id = '".$vehicleId."' AND shift = 'shift2'");
				if(mysqli_num_rows($chkShiftRs)>0){
					$chkShiftRec = mysqli_fetch_array($chkShiftRs);
					if($chkShiftRec['closed']=='yes'){
						//ok
					} else {
						$error = 'Sorry. You should close Shift2 with this vehicle for the selected date';
					}
				} else {
					//shift2 not added with this vehicle. so its ok here
				}
			}*/
		}
		
		//check if the same driver already added on same date
		//$chkDrvRs = mysqli_query($con, "SELECT id FROM tbl_daily_stock WHERE date = '".$date."' AND driver_id = '".$driverId."' AND shift = '".$shift."'");
		$chkDrvRs = mysqli_query($con, "SELECT id FROM tbl_daily_stock WHERE driver_id = '".$driverId."' AND closed = 'no'");
		if(mysqli_num_rows($chkDrvRs)>0){
			$error = 'Sorry, this driver already in live vehicle';
		} else {
			//if shift2 is selected check if shift1 with same driver (if exists) closed. If not closed, show error
			/*if($shift=='shift2'){
				$chkShiftRs = mysqli_query($con, "SELECT closed FROM tbl_daily_stock WHERE date = '".$date."' AND driver_id = '".$driverId."' AND shift = 'shift1'");
				if(mysqli_num_rows($chkShiftRs)>0){
					$chkShiftRec = mysqli_fetch_array($chkShiftRs);
					if($chkShiftRec['closed']=='yes'){
						//ok
					} else {
						$error = 'Sorry. You should close Shift1 with this driver for the selected date';
					}
				} else {
					//shift1 not added with this driver. so its ok here
				}
			}
			//if shift1 is selected check if shift2 with same driver (if exists) closed. If not closed, show error
			if($shift=='shift1'){
				$chkShiftRs = mysqli_query($con, "SELECT closed FROM tbl_daily_stock WHERE date = '".$date."' AND driver_id = '".$driverId."' AND shift = 'shift2'");
				if(mysqli_num_rows($chkShiftRs)>0){
					$chkShiftRec = mysqli_fetch_array($chkShiftRs);
					if($chkShiftRec['closed']=='yes'){
						//ok
					} else {
						$error = 'Sorry. You should close Shift2 with this driver for the selected date';
					}
				} else {
					//shift2 not added with this driver. so its ok here
				}
			}*/
		}
		
		

		
				
		if(empty($error)) {
			
			$addedBy = $_SESSION['adminId'];
				
			$insertQry = "INSERT INTO tbl_daily_stock(shift, warehouse_id, driver_id, vehicle_id, helper_id, date, opening_time, added_on, added_by) VALUES (
			 '".mysqli_real_escape_string($con, $shift)."',
			 '".mysqli_real_escape_string($con, $warehouseId)."',
			 '".mysqli_real_escape_string($con, $driverId)."',			 
			 '".mysqli_real_escape_string($con, $vehicleId)."',
			 '".mysqli_real_escape_string($con, $helperId)."',
			 '".mysqli_real_escape_string($con, $date)."',			 
			 '".mysqli_real_escape_string($con, $openingTime)."',
			 '".$curDate."',
			 '".mysqli_real_escape_string($con, $addedBy)."')";
			
			$execInsert = mysqli_query($con,$insertQry);
			$insert_id = mysqli_insert_id($con);		
			
			if($execInsert) {
				
				foreach ($submitProds as $pId => $pStock) {
					mysqli_query($con, "INSERT INTO tbl_daily_stock_products (daily_stock_id, prod_id, opening_stock) VALUES ('".$insert_id."', '".$pId."', '".$pStock."')");
				}
				
				//make the driver availability on
				mysqli_query($con, "UPDATE tbl_technician SET availability = 'on' WHERE id = '".$driverId."'");
																		
				$success = 'Opening Stock Added Successfully';
				header('Location:index.php?page=manage_daily_stock&success='.$success);
				exit();			
			} else {
				$error = 'Unable to add opening stock';
			}		
		}		
	} 
}

if(isset($_POST['update'])) {
		
	if(isset($_POST['opening_time']) && strlen($_POST['opening_time'])>0) {		
		$openingTime = mysqli_real_escape_string($con, trim($_POST['opening_time']));
		$curTime = $openingTime;
		$openingTime = str_replace(' ', '', $openingTime);
	} else {
		$error = 'Please select a helper';
	}

	/*if(isset($_POST['opening_stock']) && strlen($_POST['opening_stock'])>0) {
		$openingStock = mysqli_real_escape_string($con, trim($_POST['opening_stock']));
		if(is_numeric($openingStock)){
			if($openingStock>0 && $openingStock<1000){
				//ok
			} else {
				$error = 'The opening stock should be between 0 and 1000';
			}
		} else {
			$error = 'Enter a numeric value for opening stock';
		}
	} else {
		$error = 'Please enter opening stock';
	}*/
	
	$productRs = mysqli_query($con, "SELECT id, name FROM tbl_products WHERE status = 'Active'");
	if(mysqli_num_rows($productRs)>0){
		$submitProds = array();
		while($productRec = mysqli_fetch_array($productRs)){
			if(isset($_POST['opening_stock'.$productRec['id']]) && $_POST['opening_stock'.$productRec['id']]!=''){
				$openingStock = $_POST['opening_stock'.$productRec['id']];
				if(is_numeric($openingStock)){
					if($openingStock>=0 && $openingStock<1000){
						$submitProds[$productRec['id']] = $openingStock;
					} else {
						$error = 'The opening stock should be between 0 and 1000';
					}
				} else {
					$error = 'Enter a numeric value for opening stock of '.$productRec['name'];
				}				
			} else {
				$error = 'Enter opening stock of '.$productRec['name'];
			}
		}
	}

	if(isset($_POST['helper']) && strlen($_POST['helper'])>0) {
		$helperId = mysqli_real_escape_string($con, trim($_POST['helper']));
	} else {
		//$error = 'Please select a helper';
		$helperId = "";
	}

	if(isset($_POST['vehicle']) && strlen($_POST['vehicle'])>0) {
		$vehicleId = mysqli_real_escape_string($con, trim($_POST['vehicle']));
	} else {
		$error = 'Please select a vehicle';
	}
	
	if(isset($_POST['driver']) && strlen($_POST['driver'])>0) {
		$driverId = mysqli_real_escape_string($con, trim($_POST['driver']));
	} else {
		$error = 'Please select a driver';
	}

	if(isset($_POST['warehouse']) && strlen($_POST['warehouse'])>0) {
		$warehouseId = mysqli_real_escape_string($con, trim($_POST['warehouse']));
	} else {
		$error = 'Please select warehouse';
	}
	
	if(isset($_POST['shift']) && strlen($_POST['shift'])>0) {
		$shift = mysqli_real_escape_string($con, trim($_POST['shift']));		
	} else {
		$error = 'Please select shift';
	}
	
	if(strlen(trim($_POST['date'])) > 0) {
		$date = mysqli_real_escape_string($con, trim($_POST['date']));	
		if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$date)) {
		    //ok - yyyy-mm-dd
		} else {
		    $dateArr = explode('-', $date);
			$date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
		}	
	} else {
		$error = 'Please select date';
	}
					
	if(empty($error)) {
		
		//check if the same helper already added on same date
		$chkHelpRs = mysqli_query($con, "SELECT id FROM tbl_daily_stock WHERE date = '".$date."' AND helper_id = '".$helperId."' AND shift = '".$shift."' AND id != '".$editId."'");
		if(mysqli_num_rows($chkHelpRs)>0){
			$error = 'Sorry, this helper already added for the same date with shift '.$shift;
		} else {
			//if shift2 is selected check if shift1 with same helper (if exists) closed. If not closed, show error
			if($shift=='shift2'){
				$chkShiftRs = mysqli_query($con, "SELECT closed FROM tbl_daily_stock WHERE date = '".$date."' AND helper_id = '".$helperId."' AND shift = 'shift1' AND id != '".$editId."'");
				if(mysqli_num_rows($chkShiftRs)>0){
					$chkShiftRec = mysqli_fetch_array($chkShiftRs);
					if($chkShiftRec['closed']=='yes'){
						//ok
					} else {
						$error = 'Sorry. You should close Shift1 with this helper for the selected date';
					}
				} else {
					//shift1 not added with this helper. so its ok here
				}
			}
			//if shift1 is selected check if shift2 with same helper (if exists) closed. If not closed, show error
			if($shift=='shift1'){
				$chkShiftRs = mysqli_query($con, "SELECT closed FROM tbl_daily_stock WHERE date = '".$date."' AND helper_id = '".$helperId."' AND shift = 'shift2' AND id != '".$editId."'");
				if(mysqli_num_rows($chkShiftRs)>0){
					$chkShiftRec = mysqli_fetch_array($chkShiftRs);
					if($chkShiftRec['closed']=='yes'){
						//ok
					} else {
						$error = 'Sorry. You should close Shift2 with this helper for the selected date';
					}
				} else {
					//shift2 not added with this helper. so its ok here
				}
			}
		}
		
		//check if the same vehicle already added on same date
		$chkVehRs = mysqli_query($con, "SELECT id FROM tbl_daily_stock WHERE date = '".$date."' AND vehicle_id = '".$vehicleId."' AND shift = '".$shift."' AND id != '".$editId."'");
		if(mysqli_num_rows($chkVehRs)>0){
			$error = 'Sorry, this vehicle already added for the same date with shift '.$shift;
		} else {
			//if shift2 is selected check if shift1 with same vehicle (if exists) closed. If not closed, show error
			if($shift=='shift2'){
				$chkShiftRs = mysqli_query($con, "SELECT closed FROM tbl_daily_stock WHERE date = '".$date."' AND vehicle_id = '".$vehicleId."' AND shift = 'shift1' AND id != '".$editId."'");
				if(mysqli_num_rows($chkShiftRs)>0){
					$chkShiftRec = mysqli_fetch_array($chkShiftRs);
					if($chkShiftRec['closed']=='yes'){
						//ok
					} else {
						$error = 'Sorry. You should close Shift1 with this vehicle for the selected date';
					}
				} else {
					//shift1 not added with this vehicle. so its ok here
				}
			}
			//if shift1 is selected check if shift2 with same vehicle (if exists) closed. If not closed, show error
			if($shift=='shift1'){
				$chkShiftRs = mysqli_query($con, "SELECT closed FROM tbl_daily_stock WHERE date = '".$date."' AND vehicle_id = '".$vehicleId."' AND shift = 'shift2' AND id != '".$editId."'");
				if(mysqli_num_rows($chkShiftRs)>0){
					$chkShiftRec = mysqli_fetch_array($chkShiftRs);
					if($chkShiftRec['closed']=='yes'){
						//ok
					} else {
						$error = 'Sorry. You should close Shift2 with this vehicle for the selected date';
					}
				} else {
					//shift2 not added with this vehicle. so its ok here
				}
			}
		}
		
		//check if the same driver already added on same date
		$chkDrvRs = mysqli_query($con, "SELECT id FROM tbl_daily_stock WHERE date = '".$date."' AND driver_id = '".$driverId."' AND shift = '".$shift."' AND id != '".$editId."'");
		if(mysqli_num_rows($chkDrvRs)>0){
			$error = 'Sorry, this driver already added for the same date with shift '.$shift;
		} else {
			//if shift2 is selected check if shift1 with same driver (if exists) closed. If not closed, show error
			if($shift=='shift2'){
				$chkShiftRs = mysqli_query($con, "SELECT closed FROM tbl_daily_stock WHERE date = '".$date."' AND driver_id = '".$driverId."' AND shift = 'shift1' AND id != '".$editId."'");
				if(mysqli_num_rows($chkShiftRs)>0){
					$chkShiftRec = mysqli_fetch_array($chkShiftRs);
					if($chkShiftRec['closed']=='yes'){
						//ok
					} else {
						$error = 'Sorry. You should close Shift1 with this driver for the selected date';
					}
				} else {
					//shift1 not added with this driver. so its ok here
				}
			}
			//if shift1 is selected check if shift2 with same driver (if exists) closed. If not closed, show error
			if($shift=='shift1'){
				$chkShiftRs = mysqli_query($con, "SELECT closed FROM tbl_daily_stock WHERE date = '".$date."' AND driver_id = '".$driverId."' AND shift = 'shift2' AND id != '".$editId."'");
				if(mysqli_num_rows($chkShiftRs)>0){
					$chkShiftRec = mysqli_fetch_array($chkShiftRs);
					if($chkShiftRec['closed']=='yes'){
						//ok
					} else {
						$error = 'Sorry. You should close Shift2 with this driver for the selected date';
					}
				} else {
					//shift2 not added with this driver. so its ok here
				}
			}
		}
							
		//check if the same driver already added on same date
		/*$chkDrvRs = mysqli_query($con, "SELECT id FROM tbl_daily_stock WHERE date = '".$date."' AND driver_id = '".$driverId."' AND id != '".$editId."'");
		if(mysqli_num_rows($chkDrvRs)>0){
			$error = 'Sorry, this driver already added for the same date';
		}
		
		//check if the same vehicle already added on same date
		$chkVehRs = mysqli_query($con, "SELECT id FROM tbl_daily_stock WHERE date = '".$date."' AND vehicle_id = '".$vehicleId."' AND id != '".$editId."'");
		if(mysqli_num_rows($chkVehRs)>0){
			$error = 'Sorry, this vehicle already added for the same date';
		}

		//check if the same helper already added on same date
		$chkHelpRs = mysqli_query($con, "SELECT id FROM tbl_daily_stock WHERE date = '".$date."' AND helper_id = '".$helperId."' AND id != '".$editId."'");
		if(mysqli_num_rows($chkHelpRs)>0){
			$error = 'Sorry, this helper already added for the same date';
		}*/	
		
		if(empty($error)){
			
			$updateQry = "UPDATE tbl_daily_stock SET warehouse_id = '".$warehouseId."', driver_id = '".$driverId."', vehicle_id = '".$vehicleId."', helper_id = '".$helperId."', 
			date = '".$date."', opening_time = '".$openingTime."', updated_by = '".$_SESSION['adminId']."', updated_on = '".$curDate."'  WHERE id = '".$editId."'";
			$execUpdate = mysqli_query($con,$updateQry);	
			
			foreach ($submitProds as $pId => $pStock) {
				mysqli_query($con, "UPDATE tbl_daily_stock_products SET opening_stock = '".$pStock."' WHERE daily_stock_id = '".$editId."' AND prod_id = '".$pId."'");
			}
							
			if($execUpdate) {							
				
				$success = 'Opening Stock Updated Successfully';
				header('Location:index.php?page=manage_daily_stock&success='.$success);
				exit();			
			} else {
				$error = 'Unable to update details';
			}		
		}			
	} 
}

?>