<?php
/*
* date last modified 23-10-2019
* Edited by PI-Digi Logical Solutions
* HTML Files - manage_staff.html.php
* Mysql Tables - tbl_job, tbl_products, tbl_technician, tbl_vehicle, tbl_city
*/
require_once('./classes/class.noseo_pagination.php'); # pagination class
require_once('./includes/functions.php'); # general functions

if(isset($_REQUEST['p']) && $_REQUEST['p']!=''){
	$p = trim($_REQUEST['p']);
} else {
	$p = 1;
}
$pageVars = '';
//$where = ' id > 0 ';
$where = ' ';
$joinWhere = ' ';
$orderBy = " ORDER BY id DESC ";
$addUnion = FALSE;

if(isset($_POST['clear'])) {
?>
<script language="javascript" type="text/javascript">
	window.location='index.php?page=<?php echo $page;?>&clear=yes';
</script>
<?php
}
$statRs = mysqli_query($con, "SELECT DISTINCT status FROM tbl_job WHERE is_project != 'yes'");
$productRs = mysqli_query($con, "SELECT id, name FROM tbl_products WHERE status = 'Active'");
$driverRs = mysqli_query($con, "SELECT id, name FROM tbl_technician WHERE status != 'Deleted' ORDER BY name");
$vehicleRs = mysqli_query($con, "SELECT id, number FROM tbl_vehicle WHERE status = 'Active'");
$cityRs = mysqli_query($con, "SELECT id, name FROM tbl_city WHERE status = 'Active'");

if(isset($_GET['action']) && $_GET['action'] == 'delete') {
	/* Delete User */
	if(isset($_GET['del_id']) && $_GET['del_id']!=''){
		$delId = trim($_GET['del_id']);
		//delete all extra tech requests
		//mysqli_query($con, "DELETE FROM tbl_job_extra_tech WHERE job_id = '".$_GET['del_id']."' AND technician_id = '0'");
		$delete = mysqli_query($con,'DELETE FROM tbl_job WHERE id='.$delId);
		if($delete) {
			//delete cylinder returns with this order
			mysqli_query($con, "DELETE FROM tbl_job_cylinder WHERE job_id = '".$delId."'");
			mysqli_query($con, "DELETE FROM tbl_technician_payments WHERE job_id = '".$delId."'");
			mysqli_query($con, "DELETE FROM tbl_wallet_used WHERE order_id = '".$delId."'");			
			$success = 'The order - '.$delId.' has been deleted';
			?>
	        <script language="javascript" type="text/javascript">
				window.location='index.php?page=<?php echo $page;?>&success=<?php echo $success; ?>&p=<?php echo $p;?>';
			</script>
	        <?php
		}
	}
}

if(isset($_GET['action']) && $_GET['action'] == 'discard') {
	if(isset($_GET['id']) && $_GET['id']!=''){
		$taskId = trim($_GET['id']);
		$update = mysqli_query($con,"UPDATE tbl_job SET status = 'discarded' WHERE id = '".$taskId."'");
		if($update) {
			//remove all payments of the task
			mysqli_query($con, "DELETE FROM tbl_technician_payments WHERE job_id = '".$taskId."'");
			$success = 'Discarded the order - $taskId';
			?>
	        <script language="javascript" type="text/javascript">
				window.location='index.php?page=<?php echo $page;?>&success=<?php echo $success; ?>&p=<?php echo $p;?>';
			</script>
	        <?php
		}
	}
}

$pageVars = '';

// Get All User details to list
$prodwhere = ' id > 0 ';

if(isset($_REQUEST['task_status']) && strlen($_REQUEST['task_status'])>0) {
	$taskStatus = $_REQUEST['task_status'];
	if($taskStatus=='pending'){
		$where .= " AND status!='paid' ";
		$joinWhere .= " AND j.status!='paid' ";
	} else if($taskStatus=='Unassigned'){
		$where .= " AND status='New' AND now = 'yes' ";
		$joinWhere .= " AND j.status='New' AND now = 'yes' ";
	} else if($taskStatus=='New'){
		$where .= " AND status='New' AND now != 'yes' ";
		$joinWhere .= " AND j.status='New' AND now != 'yes' ";
	} else {
		$where .= " AND status='".$taskStatus."' ";
		$joinWhere .= " AND j.status='".$taskStatus."' ";
	}
	$pageVars.= '&task_status='.$taskStatus.'&';
}

if(isset($_REQUEST['driver_id']) && $_REQUEST['driver_id']!='') {
	$taskTechId = trim($_REQUEST['driver_id']);
	$where .= " AND technician_id = '".$taskTechId."' ";
	$joinWhere .= " AND technician_id = '".$taskTechId."' ";
	$prodwhere .= " AND technician_id = '".$taskTechId."' ";
	$pageVars.= '&driver_id='.$taskTechId.'&';
}

if(isset($_REQUEST['status']) && $_REQUEST['status']=='closing') {
	$where .= " AND (status='assigned' OR status='start_off' OR status='arrived' OR status='completed') ";
	$joinWhere .= " AND (j.status='assigned' OR j.status='start_off' OR j.status='arrived' OR j.status='completed') ";
	$pageVars.= '&status=closing&';
}

if(isset($_REQUEST['vehicle_id']) && $_REQUEST['vehicle_id']!='') {
	$vehicleId = trim($_REQUEST['vehicle_id']);	
	$where .= " AND vehicle_id  = '".$vehicleId."' ";
	$joinWhere .= " AND vehicle_id  = '".$vehicleId."' ";
	$prodwhere .= " AND vehicle_id  = '".$vehicleId."' ";
	$pageVars.= '&vehicle_id='.$vehicleId.'&';
}
//SELECT * FROM tbl_job WHERE id > 0 AND (id IN (SELECT id FROM tbl_job WHERE address_id = '0' AND user_id IN(SELECT id FROM tbl_user WHERE city = '20')) OR id IN (SELECT id FROM tbl_job WHERE address_id IN(SELECT id FROM tbl_user_address WHERE city = '20'))) ORDER BY id DESC

if(isset($_REQUEST['city_id']) && $_REQUEST['city_id']!='') {
	$cityId = $_REQUEST['city_id'];
	$city_ids = "";

	if (!is_array($cityId)) {
    	if($cityId!="") {
			$cityId_arr = explode(",", $cityId);
			$where .= " AND (id IN (SELECT id FROM tbl_job WHERE address_id  = '0' AND user_id IN(SELECT id FROM tbl_user WHERE city IN (".$cityId."))) OR id IN (SELECT id FROM tbl_job WHERE address_id  IN(SELECT id FROM tbl_user_address WHERE city IN (".$cityId.")))) ";
			$joinWhere .= " AND (id IN (SELECT id FROM tbl_job WHERE address_id  = '0' AND user_id IN(SELECT id FROM tbl_user WHERE city IN (".$cityId."))) OR id IN (SELECT id FROM tbl_job WHERE address_id  IN(SELECT id FROM tbl_user_address WHERE city IN (".$cityId.")))) ";
			$pageVars.= 'city_id='.$cityId.'&';
		}
	} else {
		foreach($cityId as $cid) {
			$city_ids .= $cid.',';
		}
		$cityId_arr = explode(",", $city_ids);
		if($city_ids!="") {
			$where .= " AND (id IN (SELECT id FROM tbl_job WHERE address_id  = '0' AND user_id IN(SELECT id FROM tbl_user WHERE city IN (".substr($city_ids,0,-1)."))) OR id IN (SELECT id FROM tbl_job WHERE address_id  IN(SELECT id FROM tbl_user_address WHERE city IN (".substr($city_ids,0,-1).")))) ";
			$joinWhere .= " AND (id IN (SELECT id FROM tbl_job WHERE address_id  = '0' AND user_id IN(SELECT id FROM tbl_user WHERE city IN (".substr($city_ids,0,-1)."))) OR id IN (SELECT id FROM tbl_job WHERE address_id  IN(SELECT id FROM tbl_user_address WHERE city IN (".substr($city_ids,0,-1).")))) ";
			$pageVars.= 'city_id='.$city_ids.'&';
		}
	}	
}

if(isset($_REQUEST['task_id']) && $_REQUEST['task_id']!='') {
	$taskId = trim($_REQUEST['task_id']);
	$keyword = $taskId;
	if(strpos($taskId, '#') !== false){
		$taskId = ltrim($taskId, '#');
	}		
	$where.= " AND (j.id = '".$keyword."' OR u.name LIKE '%".$keyword."%' OR u.email LIKE '%".$keyword."%' OR u.phone LIKE '%".$keyword."%' OR FIND_IN_SET('".$keyword."',u.additional_numbers) OR u.booklet_id = '".$keyword."') ";
	$joinWhere.= " AND (j.id = '".$keyword."' OR u.name LIKE '%".$keyword."%' OR u.email LIKE '%".$keyword."%' OR u.phone LIKE '%".$keyword."%' OR FIND_IN_SET('".$keyword."',u.additional_numbers) OR u.booklet_id = '".$keyword."') ";
	$pageVars .=  "&task_id=".$keyword."&";
	
	//check if order id exist with this keyword
	$chkRs = mysqli_query($con, "SELECT id FROM tbl_job WHERE id = '".$keyword."'");
	if(mysqli_num_rows($chkRs)>0){
		$addUnion = TRUE;
	}
	
}

if(isset($_REQUEST['stock_id']) && $_REQUEST['stock_id']!='') {
	$dailyStockId = trim($_REQUEST['stock_id']);
	$where .= " AND daily_stock_id = '".$dailyStockId."' ";
	$joinWhere .= " AND daily_stock_id = '".$dailyStockId."' ";
	$prodwhere .= " AND daily_stock_id = '".$dailyStockId."' ";
	$pageVars.= '&stock_id='.$dailyStockId.'&';
}

if(isset($_REQUEST['date_to']) && strlen($_REQUEST['date_to'])>0) {

	$to_date_req = trim($_REQUEST['date_to']);
	if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$to_date_req)) {
	    //ok - yyy-mm-dd
	    $to_date = $to_date_req;
	} else {
	    $dateArr = explode('-', $to_date_req);
		$to_date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
	}
} else {
	if(!isset($_REQUEST['clear'])){
		$to_date = date('Y-m-d');
		$to_date_req = date('d-m-Y');
	} else {
		$to_date = '';	
		$to_date_req = '';
	}
	
}

if(isset($_REQUEST['from_date']) && strlen($_REQUEST['from_date'])>0) {
	$from_date_req = trim($_REQUEST['from_date']);
	if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$from_date_req)) {
	    //ok - yyy-mm-dd
	    $from_date = $from_date_req;
	} else {
	    $dateArr = explode('-', $from_date_req);
		$from_date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
	}
} else {
	if(!isset($_REQUEST['clear'])){
		$from_date = date('Y-m-d');
		$from_date_req = date('d-m-Y');
	} else {
		$from_date = '';	
		$from_date_req = '';
	}	
}

if(isset($_REQUEST['date']) && strlen($_REQUEST['date'])>0) {
	$date = trim($_REQUEST['date']);
	if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$date)) {
	    //ok - yyy-mm-dd
	} else {
	    $dateArr = explode('-', $date);
		$date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
	}
} else {
	$date = '';
}

$curDate = date('Y-m-d');

if(isset($_REQUEST['status']) && $_REQUEST['status']=='closing') {
	//we should override the date filter
} else {
	if(isset($keyword) && $keyword!='') {
		
	} else {
		if($from_date!='' && $to_date!=''){
			$where .= " AND task_date BETWEEN '".$from_date."' AND '".$to_date."' ";
			$joinWhere .= " AND task_date BETWEEN '".$from_date."' AND '".$to_date."' ";
			$prodwhere .= " AND task_date BETWEEN '".$from_date."' AND '".$to_date."' ";
			$pageVars.= '&from_date='.$from_date_req.'&date_to='.$to_date_req.'&';
		} else if($from_date!=''){	
			$where .= " AND task_date BETWEEN '".$from_date."' AND '".$curDate."' ";
			$joinWhere .= " AND task_date BETWEEN '".$from_date."' AND '".$curDate."' ";
			$prodwhere .= " AND task_date BETWEEN '".$from_date."' AND '".$curDate."' ";
			$pageVars.= '&from_date='.$from_date_req.'&';
		} else if($to_date!=''){	
			$where .= " AND task_date BETWEEN '".$to_date."' AND '".$curDate."' ";
			$joinWhere .= " AND task_date BETWEEN '".$to_date."' AND '".$curDate."' ";
			$prodwhere .= " AND task_date BETWEEN '".$to_date."' AND '".$curDate."' ";
			$pageVars.= '&date_to='.$to_date_req.'&';
		} else if($date!=''){	
			$where .= " AND task_date = '".$date."' ";
			$joinWhere .= " AND task_date = '".$date."' ";
			$prodwhere .= " AND task_date = '".$date."' ";
			$pageVars.= '&date='.$_REQUEST['date'].'&';
		} 
	}	
}

if(isset($_REQUEST['pay_type']) && strlen($_REQUEST['pay_type'])>0) {
	if(isset($keyword) && $keyword!='') {
	} else {
		$payType = $_REQUEST['pay_type'];
		$where .= " AND id IN (SELECT job_id FROM tbl_technician_payments WHERE payment_method = '".$payType."') ";	 	
		$joinWhere .= " AND id IN (SELECT job_id FROM tbl_technician_payments WHERE payment_method = '".$payType."') ";	 	
		$pageVars.= 'pay_type='.$payType.'&';
	}
}

if(isset($_REQUEST['source']) && strlen($_REQUEST['source'])>0) {
	$source = $_REQUEST['source'];
	$where .= " AND `source` = '".$source."' ";	
	$joinWhere .= " AND `source` = '".$source."' ";	 	
	$pageVars.= 'source='.$source.'&';	
}

if(isset($_REQUEST['sale_type']) && strlen($_REQUEST['sale_type'])>0) {
	$saleType = $_REQUEST['sale_type'];
	$where .= " AND `sale_type` = '".$saleType."' ";	
	$joinWhere .= " AND `sale_type` = '".$saleType."' ";	 	
	$pageVars.= 'sale_type='.$saleType.'&';	
}

if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='pending_dsc'){	
	//get pending orders of all drivers and in live stock
	$pendingDrivers = array();
	$pendingDriverString = '';
	$pendingDriverRs = mysqli_query($con, "SELECT DISTINCT driver_id FROM tbl_daily_stock WHERE closed = 'no'");
	if(mysqli_num_rows($pendingDriverRs)>0){
		while($pendingDriverRec = mysqli_fetch_array($pendingDriverRs)){
			$pendingDriverId = $pendingDriverRec['driver_id'];
			//get pending order count
			$pendingOrderRec = mysqli_fetch_array(mysqli_query($con, "SELECT count(id) AS count FROM tbl_job WHERE technician_id = '".$pendingDriverId."' AND `status` != 'paid'"));
			$pendingOrderCount1 = $pendingOrderRec['count'];
			$pendingDrivers[$pendingDriverId] = $pendingOrderCount1;
		}
		if(count($pendingDrivers)>0){
			//sort by desc
			arsort($pendingDrivers);
			//print_r($pendingDrivers);
			//$pendingDriverString = implode(',', $pendingDrivers);
			$pendingDriverString = implode(',',array_keys($pendingDrivers));
			$orderBy = " AND technician_id IN(".$pendingDriverString.") ORDER BY FIELD(technician_id,".$pendingDriverString.") ";
		}
	}
	$pageVars.= 'orderby=pending_dsc&';
} else if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='pending_asc'){	
	//get pending orders of all drivers and in live stock
	$pendingDrivers = array();
	$pendingDriverString = '';
	$pendingDriverRs = mysqli_query($con, "SELECT DISTINCT driver_id FROM tbl_daily_stock WHERE closed = 'no'");
	if(mysqli_num_rows($pendingDriverRs)>0){
		while($pendingDriverRec = mysqli_fetch_array($pendingDriverRs)){
			$pendingDriverId = $pendingDriverRec['driver_id'];
			//get pending order count
			$pendingOrderRec = mysqli_fetch_array(mysqli_query($con, "SELECT count(id) AS count FROM tbl_job WHERE technician_id = '".$pendingDriverId."' AND `status` != 'paid'"));
			$pendingOrderCount1 = $pendingOrderRec['count'];
			$pendingDrivers[$pendingDriverId] = $pendingOrderCount1;
		}
		if(count($pendingDrivers)>0){
			//sort by desc
			asort($pendingDrivers);
			//print_r($pendingDrivers);
			//$pendingDriverString = implode(',', $pendingDrivers);
			$pendingDriverString = implode(',',array_keys($pendingDrivers));
			$orderBy = " AND technician_id IN(".$pendingDriverString.") ORDER BY FIELD(technician_id,".$pendingDriverString.") ";
		}
	}
	$pageVars.= 'orderby=pending_dsc&';
} else if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='orderid_asc'){
	$orderBy = " ORDER BY id ASC ";
	$pageVars.= 'orderby=orderid_asc&';
} else if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='orderid_dsc'){
	$orderBy = " ORDER BY id DESC ";
	$pageVars.= 'orderby=orderid_dsc&';
} else if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='booked_on_asc'){
	$orderBy = " ORDER BY date ASC ";
	$pageVars.= 'orderby=booked_on_asc&';
} else if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='booked_on_dsc'){
	$orderBy = " ORDER BY date DESC ";
	$pageVars.= 'orderby=booked_on_dsc&';
} else if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='booked_for_asc'){
	$orderBy = " ORDER BY task_date ASC, task_time ASC ";
	$pageVars.= 'orderby=booked_for_asc&';
} else if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='booked_for_dsc'){
	$orderBy = " ORDER BY task_date DESC, task_time DESC ";
	$pageVars.= 'orderby=booked_for_dsc&';
} else if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='status_asc'){
	$orderBy = " ORDER BY status ASC ";
	$pageVars.= 'orderby=status_asc&';
} else if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='status_dsc'){
	$orderBy = " ORDER BY status DESC ";
	$pageVars.= 'orderby=status_dsc&';
} 

if($orderBy!= " ORDER BY id DESC "){
	if(isset($_REQUEST['clear']) && $_REQUEST['clear']=='yes') {
		$pageVars .= '&clear=yes&';			
	}
}

if(isset($_REQUEST['prod_id']) && $_REQUEST['prod_id']!='') {
	if(isset($keyword) && $keyword!='') {
	} else {
		$prodId = trim($_REQUEST['prod_id']);	
		$prodwhere .= " AND prod_id = '".$prodId."' ";	
		$where .= " AND prod_id = '".$prodId."' ";
		$joinWhere .= " AND prod_id = '".$prodId."' ";	
		$pageVars.= 'prod_id='.$prodId.'&';
	}
	
} else {
	$prodwhere .= " AND prod_id > '0' ";	
}


if($addUnion){
	//we cannot use order by in this query as we should show the order with id=keyword on top
	$select = "(SELECT j.* FROM `tbl_job` j INNER JOIN tbl_user u ON j.user_id = u.id WHERE j.id = '188') UNION (SELECT j.* FROM `tbl_job` j INNER JOIN tbl_user u ON j.user_id = u.id WHERE j.id > 0 ".$joinWhere." AND j.user_id=u.id)";
} else {
	if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='customer_asc'){
		$orderBy = " ORDER BY user_id ASC ";
		$pageVars.= 'orderby=customer_asc&';
		if((isset($_REQUEST['clear']) && $_REQUEST['clear']=='yes') && (!isset($_POST['search']) && !isset($_POST['export']))) {
			$select = "SELECT j.* FROM `tbl_job` j INNER JOIN tbl_user u ON j.user_id = u.id WHERE j.id > 0 ".$joinWhere." AND j.user_id=u.id ORDER BY u.name ";
		} else {
			$select = "SELECT * FROM tbl_job WHERE id > 0 ".$orderBy;
		}
	} else if(isset($_REQUEST['orderby']) && $_REQUEST['orderby']=='customer_dsc'){
		$orderBy = " ORDER BY user_id DESC ";
		$pageVars.= 'orderby=customer_dsc&';
		if((isset($_REQUEST['clear']) && $_REQUEST['clear']=='yes') && (!isset($_POST['search']) && !isset($_POST['export']))) {
			$select = "SELECT j.* FROM `tbl_job` j INNER JOIN tbl_user u ON j.user_id = u.id WHERE j.id > 0 ".$joinWhere." AND j.user_id=u.id ORDER BY u.name DESC ";
		} else {
			$select = "SELECT * FROM tbl_job WHERE id > 0 ".$orderBy;
		}
	} else {	
		if(isset($taskId) && $taskId!='') {
			$select = "SELECT j.* FROM `tbl_job` j INNER JOIN tbl_user u ON j.user_id = u.id WHERE j.id > 0 ".$joinWhere." AND j.user_id=u.id ORDER BY u.name DESC ";
		} else {
			$select = "SELECT * FROM tbl_job WHERE id > 0 ".$where.$orderBy;
		}
	}
}

if((isset($_REQUEST['clear']) && $_REQUEST['clear']=='yes') && (!isset($_POST['search']) && !isset($_POST['export']))) {
	$pageVars .= '&clear=yes&';
}

/*if($orderBy!= " ORDER BY id DESC"){
	if(isset($_REQUEST['clear']) && $_REQUEST['clear']=='yes') {
		$pageVars .= '&clear=yes&';			
	}
}*/


/*if($_SERVER['REMOTE_ADDR']=='202.88.237.77'){
	echo($select);
}*/

$soldCountRec = mysqli_fetch_array(mysqli_query($con, "SELECT SUM(quantity) AS quantity FROM tbl_job WHERE ".$prodwhere." AND status = 'paid' "));
/*if($_SERVER['REMOTE_ADDR']=='202.88.237.77'){
	echo "SELECT SUM(quantity) AS quantity FROM tbl_job WHERE ".$prodwhere." AND status = 'paid' ";
}*/


// Using pagination class
$pagination = new pagination_noseo($select);
$execDetails = $pagination->createPages(30, $con);

$pageLnk = 'index.php?page='.$page.'&'.$pageVars;
$pageNums = $pagination->pageNumber(5, $pageLnk);

if(isset($_POST['export'])) {
	include '../export/DBController.php';
	$db_handle = new DBController();
	//echo "SELECT id, user_id, date, task_date, task_time, status FROM tbl_job WHERE id > 0 ".$where." ORDER BY id DESC"; exit;
	$productResult = $db_handle->runQuery("SELECT * FROM tbl_job WHERE id > 0 ".$where." ORDER BY id DESC");
	
	//get service location of all drivers and store in an array
	$serviceLocArray = array();
	$serviceLocRs = mysqli_query($con, "SELECT technician_id, location FROM tbl_technician_location");
	if(mysqli_num_rows($serviceLocRs)>0){
		while($serviceLocRec = mysqli_fetch_array($serviceLocRs)){
			$serviceDriverId = $serviceLocRec['technician_id'];
			$serviceLocation = $serviceLocRec['location'];
			$serviceLocArray[$serviceDriverId]=$serviceLocation;
		}
	}	

    $filename = "AdLPG-Orders-".time().".xls";
    header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"$filename\"");
    $isPrintHeader = false;
	$label = array('0'=>'Order ID','1'=>'Customer', '2'=>'Driver', '3'=>'Service Location', '4'=>'Vehicle','5'=>'Booked On','6'=>'Booked For','7'=>'Status','8'=>'Cylinder Size','9'=>'Unit Price','10'=>'VAT(%)','11'=>'Quantity','12'=>'Total Amount','13'=>'Sale Type','14'=>'Payment Mode','15'=>'Description','16'=>'Notes');
    if (! empty($productResult)) {
        foreach ($productResult as $row) {

			//get vehicle, driver
			$vehicleId = $cylinderSize = '';
			$unitPrice = $vatPercent = $vatAmount = $prodQuantity = $totalAmount = 0;
			$driverId = $row['technician_id'];
			$paymentMethod = $serviceLocation = '';
			if($row['daily_stock_id']>0){
				$dailyStockRec = mysqli_fetch_array(mysqli_query($con, "SELECT vehicle_id FROM tbl_daily_stock WHERE id = '".$row['daily_stock_id']."'"));
				$vehicleId = $dailyStockRec['vehicle_id'];
				//get payment method
				$pamentRs = mysqli_query($con, "SELECT `payment_method` FROM `tbl_technician_payments` WHERE `job_id` = '".$row['id']."'");
				if(mysqli_num_rows($pamentRs)>0){
					$pamentRec = mysqli_fetch_array($pamentRs);
					$paymentMethod = $pamentRec['payment_method'];
				}
			} else if($row['technician_id']>0){
				$dailyStockRs = mysqli_query($con, "SELECT vehicle_id FROM tbl_daily_stock WHERE driver_id = '".$row['technician_id']."' AND closed = 'no'");
				if(mysqli_num_rows($dailyStockRs)>0){
					$dailyStockRec = mysqli_fetch_array($dailyStockRs);
					$vehicleId = $dailyStockRec['vehicle_id'];
				}								
			}
			if($row['technician_id']>0){
				$serviceLocation = $serviceLocArray[$row['technician_id']];
			}

			if($row['prod_id']>0){
				$cylinderSize = getProductName($row['prod_id']);
			}
			$unitPrice = $row['unit_price'];
			$vatPercent = $row['tax_percent'];
			$vatAmount = $row['tax_amount'];
			$totalAmount = ($unitPrice*$row['quantity'])+$vatAmount;
			$totalAmount = number_format((float)$totalAmount, 2, '.', '');
			
			//get notes added by admin
			$notes = '';
			$notesRs = mysqli_query($con, "SELECT `note` FROM `tbl_job_notes` WHERE `task_id` = '".$row['id']."'");
			if(mysqli_num_rows($notesRs)>0){
				while($noteRec = mysqli_fetch_array($notesRs)){
					$note = str_replace(',', '', $noteRec['note']);				
					$notes .= $note.'    ';
				}
			}
			$details = str_replace(',', '', $row['details']);

            if (! $isPrintHeader) {
                //echo implode("\t", array_keys($row)) . "\n";
				echo implode("\t", $label) . "\n";
                $isPrintHeader = true;
            }

			//echo implode("\t", array_values($row)) . "\n"; 
			if($row['status']=='assigned'){
				$orderStatVal = 'Assigned';
			} else if($row['status']=='start_off'){
				$orderStatVal = 'On the way';
			} else if($row['status']=='arrived'){
				$orderStatVal = 'Arrived';
			} else if($row['status']=='completed'){
				$orderStatVal = 'Delivered';
			} else if($row['status']=='paid'){
				$orderStatVal = 'Payment Completed';
			} else if($row['status']=='New'){
				if($row['now']=='yes'){
					$orderStatVal = 'New';
				} else {
					$orderStatVal = 'Scheduled';
				}					
			} else {
				$orderStatVal = $row['status'];
			}
			
			//$label = array('0'=>'Order ID','1'=>'Customer', '2'=>'Driver', '3'=>'Vehicle','4'=>'Booked On','5'=>'Booked For','6'=>'Status','7'=>'Cylinder Size','8'=>'Unit Price','9'=>'VAT(%)','10'=>'Quantity','11'=>'Total Amount','12'=>'Sale Type','13'=>'Payment Mode','14'=>'Description','15'=>'Notes');

			echo '#'.$row['id']."\t";
			echo getUserName($row['user_id'])."\t";
			echo getDriverName($driverId)."\t";
			echo $serviceLocation."\t";
			if($vehicleId!=''){
				echo getVehicleNumber($vehicleId)."\t";
			} else {
				echo "\t";
			}				
			echo getFormattedDateTime($row['date'])."\t";
			echo getFormattedDateTime($row['task_date'].' '.$row['task_time'])."\t";				
			echo $orderStatVal."\t";
			echo $cylinderSize."\t";
			echo $unitPrice."\t";
			echo $vatPercent."%\t";
			echo $row['quantity']."\t";
			echo $totalAmount."\t";
			echo $row['sale_type']."\t";
			echo $paymentMethod."\t";
			echo $details."\t";
			echo $notes."\t";
			echo "\n";
			//$colCount++;
		}
	}
	exit();
}


if(isset($_POST['export_count'])) {
	include '../export/DBController.php';
	$db_handle = new DBController();	
	$productResult = $db_handle->runQuery("SELECT DISTINCT task_date FROM `tbl_job` WHERE id > 0 ".$where." ORDER BY task_date");
	//echo "SELECT DISTINCT task_date FROM `tbl_job` WHERE id > 0 ".$where." ORDER BY task_date"; exit;
	
	//get all vehicles which has no sale 
	$noSaleVehicleString = '';
	$noSaleVehicleArray = array();
	//echo "SELECT id FROM tbl_vehicle WHERE id NOT IN (SELECT DISTNCT vehicle_id FROM tbl_job WHERE vehicle_id > 0 ".$where.")";
	$nosaleVehicleRs = mysqli_query($con, "SELECT id FROM tbl_vehicle WHERE id NOT IN (SELECT DISTINCT vehicle_id FROM tbl_job WHERE vehicle_id > 0 ".$where.")");
	if(mysqli_num_rows($nosaleVehicleRs)>0){
		while($nosaleVehicleRec = mysqli_fetch_array($nosaleVehicleRs)){
			$noSaleVehicleArray[] =  $nosaleVehicleRec['id'];
		}
	}
	if(count($noSaleVehicleArray)>1){
		$noSaleVehicleString = implode(',', $noSaleVehicleArray);
	} else if(count($noSaleVehicleArray)>0){
		$noSaleVehicleString = $noSaleVehicleArray[0];
	}

    $filename = "AdLPG-Order-Summary-".time().".xls";
    header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"$filename\"");
    $isPrintHeader = false;
	//$label = array('0'=>'Order ID','1'=>'Customer', '2'=>'Driver', '3'=>'Vehicle','4'=>'Booked On','5'=>'Booked For','6'=>'Status','7'=>'Cylinder Size','8'=>'Unit Price','9'=>'VAT(%)','10'=>'Quantity','11'=>'Total Amount','12'=>'Sale Type','13'=>'Payment Mode','14'=>'Description','15'=>'Notes');
	$label = array();
	$label2 = array();
	//get all vehicles
	if($noSaleVehicleString!=''){
		$vehicleRs = mysqli_query($con, "SELECT id, number FROM tbl_vehicle WHERE id NOT IN (".$noSaleVehicleString.") ORDER BY id");
		$vehicleRs2 = mysqli_query($con, "SELECT id, number FROM tbl_vehicle WHERE id NOT IN (".$noSaleVehicleString.") ORDER BY id");
	} else {
		$vehicleRs = mysqli_query($con, "SELECT id, number FROM tbl_vehicle ORDER BY id");
		$vehicleRs2 = mysqli_query($con, "SELECT id, number FROM tbl_vehicle ORDER BY id");
	}
	
	
	//creating first title row	
	$label[] = '';
	while($vehicleRec = mysqli_fetch_array($vehicleRs)){
		$productRs = mysqli_query($con, "SELECT id, name FROM tbl_products");
		$cc = 0;		
		while($productRec = mysqli_fetch_array($productRs)){
			if($cc>0){
				$label[] = '';				
			} else {
				$label[] = $vehicleRec['number'];
			}				
			$cc++;		
		}
	}
	$label[] = '';
	
	//Creating second title row
	$label2[] = 'DATE';
	while($vehicleRec = mysqli_fetch_array($vehicleRs2)){
		$productRs = mysqli_query($con, "SELECT id, name FROM tbl_products ORDER BY id");
		$cc = 0;		
		while($productRec = mysqli_fetch_array($productRs)){
			if($cc>0){
				$label2[] = $productRec['name'];				
			} else {
				$label2[] = $productRec['name'];
			}				
			$cc++;		
		}
	}
	$label2[] = 'TOTAL';
	
	//print_r($label); 
	//exit;
	$colTotal = 0;
	//associative array to store vehicles and product count sold
	$colArray = array();
	
    if (! empty($productResult)) {
        foreach ($productResult as $row) {			
			$rowTotal = 0;
            if (! $isPrintHeader) {                
				echo implode("\t", $label) . "\n";
				echo implode("\t", $label2) . "\n";
                $isPrintHeader = true;
            }
			
			$orderDate = $row['task_date'];
			echo getFormattedDate($orderDate)."\t";
			
			//get all vehicles again to find the sold count on the date
			if($noSaleVehicleString!=''){
				$vehicleRs = mysqli_query($con, "SELECT id FROM tbl_vehicle WHERE id NOT IN (".$noSaleVehicleString.") ORDER BY id");
			} else {
				$vehicleRs = mysqli_query($con, "SELECT id FROM tbl_vehicle ORDER BY id");
			}					
			while($vehicleRec = mysqli_fetch_array($vehicleRs)){
				$vehicleId = $vehicleRec['id'];
				$productRs = mysqli_query($con, "SELECT id FROM tbl_products ORDER BY id");		
				while($productRec = mysqli_fetch_array($productRs)){
					$productId = $productRec['id'];
					$soldRec = mysqli_fetch_array(mysqli_query($con, "SELECT SUM(quantity) AS quantity FROM tbl_job WHERE task_date = '".$orderDate."' AND vehicle_id = '".$vehicleId."' AND prod_id = '".$productId."'"));
					$soldCount = $soldRec['quantity'];
					$rowTotal+= $soldCount;
					if(isset($colArray[$vehicleId][$productId])){
						$colArray[$vehicleId][$productId] = $colArray[$vehicleId][$productId]+$soldCount;
					} else {
						$colArray[$vehicleId][$productId] = $soldCount;
					}
					echo $soldCount."\t";					
				}				
			}			
			echo $rowTotal."\t";		
			echo "\n";
			$colTotal+= $rowTotal;
		}

		/*if($_SERVER['REMOTE_ADDR']=='202.88.237.77'){
			print_r($colArray); exit;
		}*/
		//create the last row . display total sold count under each col
		$overallCount = 0;
		echo "TOTAL\t";
		if($noSaleVehicleString!=''){
			$vehicleRs = mysqli_query($con, "SELECT id FROM tbl_vehicle WHERE id NOT IN (".$noSaleVehicleString.") ORDER BY id");
		} else {
			$vehicleRs = mysqli_query($con, "SELECT id FROM tbl_vehicle ORDER BY id");
		}		
		while($vehicleRec = mysqli_fetch_array($vehicleRs)){
			$vehicleId = $vehicleRec['id'];
			$productRs = mysqli_query($con, "SELECT id FROM tbl_products ORDER BY id");		
			while($productRec = mysqli_fetch_array($productRs)){
				echo $colArray[$vehicleId][$productRec['id']]."\t";		
				$overallCount+=	$colArray[$vehicleId][$productRec['id']];
			}
		}
		//display the last overall total
		echo $overallCount."\t";
		
	}
//print_r($colArray);
	exit();
}


/*if(isset($_REQUEST['export_count'])) {

	require_once 'classes/PHPExcel.php';
 	$objPHPExcel = new PHPExcel();

	$objPHPExcel->setActiveSheetIndex(0);
	// Initialise the Excel row number
	$rowCount = 1;
	$col = 1;
	$dailyStockRs = mysqli_query($con, "SELECT DISTINCT date FROM `tbl_daily_stock` WHERE closed = 'no' ORDER BY date");
	if(mysqli_num_rows($dailyStockRs)>0){
		//create header
		$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'DATE');
		$vehicleRs = mysqli_query($con, "SELECT id FROM tbl_vehicle");
		while($vehicleRec = mysqli_fetch_array($vehicleRs)){
			$productTypeRs = mysqli_query($con, "SELECT id FROM tbl_products");
			while($productTypeRec = mysqli_fetch_array($productTypeRs)){
				$colVal = getVehicleNumber($vehicleRec['id']).'-'.getProductName($productTypeRec['id']);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col, $rowCount, $colVal);
				$col++;
			}
		}
		$rowCount = 2;
		$col = 2;
		//create rows
		while($dailyStockRec = mysqli_fetch_array($dailyStockRs)){
			$date = $dailyStockRec['date'];
			//$objPHPExcel->getActiveSheet()->SetCellValue('A2', $date);
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $date);
			$vehicleRs = mysqli_query($con, "SELECT id FROM tbl_vehicle");
			while($vehicleRec = mysqli_fetch_array($vehicleRs)){
				$vehicleId = $vehicleRec['id'];
				$productTypeRs = mysqli_query($con, "SELECT id FROM tbl_products");
				while($productTypeRec = mysqli_fetch_array($productTypeRs)){
					//get sold count of this product on the date. If no product sold, put zero
					/*if($_SERVER['REMOTE_ADDR']=='202.88.237.77'){
						//echo "SELECT SUM(quantity) AS quantity FROM tbl_job WHERE task_date = '".$date."' AND prod_id = '".$productTypeRec['id']."' AND vehicle_id = '".$vehicleId."' AND status = 'paid'";
						//exit;
						$orderRec = mysqli_fetch_array(mysqli_query($con, "SELECT SUM(quantity) AS quantity FROM tbl_job WHERE task_date = '2019-10-14' AND prod_id = '".$productTypeRec['id']."' AND vehicle_id = '".$vehicleId."' AND status = 'paid'"));
					} else {*/
						/*$orderRec = mysqli_fetch_array(mysqli_query($con, "SELECT SUM(quantity) AS quantity FROM tbl_job WHERE task_date = '".$date."' AND prod_id = '".$productTypeRec['id']."' AND vehicle_id = '".$vehicleId."' AND status = 'paid'"));
					//}

					$colVal = $orderRec['quantity'];
					$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col, $rowCount, $colVal);
					$col++;
				}
			}
			$rowCount++;
		}
	}
	header('Content-Type: application/vnd.ms-excel');
	header('Content-Disposition: attachment;filename="AdLPG-Order-Vehicle-'.time().'.xls"');
	header('Cache-Control: max-age=0');
	$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
	$objWriter->save('php://output');

	//to set cell color
	/*$sheet->getStyle('A1')->applyFromArray(
	    array(
	        'fill' => array(
	            'type' => PHPExcel_Style_Fill::FILL_SOLID,
	            'color' => array('rgb' => 'FF0000')
	        )
	    )
	);*/
//}*/
?>