<?php
/*
* date last modified 28-11-2017
* Edited by PI-Digi Logical Solutions
* HTML Files - add_user.html.php
* Mysql Tables - tbl_designation, tbl_staff
*/
include('includes/functions.php'); # general functions

$isEdit = FALSE;

if(isset($_REQUEST['project_id']) && $_REQUEST['project_id']!=''){		
	$projectId = mysqli_real_escape_string($con, trim($_REQUEST['project_id']));	

} else {
	header('Location:index.php?page=manage_projects');
}

//get all project expense types of this project
$projTypeRs = mysqli_query($con, "SELECT * FROM tbl_project_expense_type WHERE project_id = '".$projectId."'");


if(isset($_REQUEST['id']) && $_REQUEST['id']!=''){	
	$isEdit = TRUE;
	$editId = mysqli_real_escape_string($con, trim($_REQUEST['id']));
	$editRs = mysqli_query($con, "SELECT *, DATE(date) AS date FROM tbl_project_expense WHERE id = '".$editId."'");
	if(mysqli_num_rows($editRs)>0){
		$resEdit = mysqli_fetch_array($editRs);
		$expDateArr = explode('-',$resEdit['date']);
		$expDate = $expDateArr['2'].'-'.$expDateArr['1'].'-'.$expDateArr['0'];
	} else {
		$error = 'No expenses added';
	}	
	

} 

if(isset($_POST['add'])) {
	
	$new_category = '';
	$category = '';
	
	if(strlen(trim($_POST['description'])) > 0) {
		$description = trim($_POST['description']);
	} else {
		$description = '';
	}	
		
	if(strlen(trim($_POST['amount'])) > 0) {
		$amount = trim($_POST['amount']);
		if(is_numeric($amount) && $amount>0){
			//ok
		} else {
			$error = 'Please enter a valid amount';
		}
	} else {
		$error = 'Please enter amount';
	}
	
	if(isset($_POST['exp_date']) && strlen($_POST['exp_date'])>0) {
		$expDate = trim($_POST['exp_date']);
	} else {
		$error = 'Please select Date';
	}
	
	if(strlen(trim($_POST['category'])) > 0) {
		$category = trim($_POST['category']);
	} else {
		if(strlen(trim($_POST['new_category'])) > 0) {
			$new_category = trim($_POST['new_category']);
			//check if already added
			$chkRs = mysqli_query($con, "SELECT id FROM tbl_project_expense_type WHERE project_id = '".$projectId."' AND name = '".$new_category."'");
			if(mysqli_num_rows($chkRs)>0){
				$error = 'Sorry, the category already exist for this project';
			}
		} else {			
			$error = 'Please select an expense category or enter a new expense category';
		}		
	}
	
		
	if(empty($error)) {
		$curDate = date('Y-m-d H:i:s');			
				
		if($category!=''){		
			$insertQry = "INSERT INTO tbl_project_expense(project_id, cat_id, amount, date, description, added_by) VALUES (
			'".$projectId."',
			'".$category."',
			 '".mysqli_real_escape_string($con, $amount)."',
			 '".$expDate."',
			 '".mysqli_real_escape_string($con, $description)."',
			 '".mysqli_real_escape_string($con, $_SESSION['adminId'])."')";
		} else {
			//insert new category
			$insertCat = mysqli_query($con, "INSERT INTO tbl_project_expense_type (project_id, name) VALUES ('".$projectId."', '".$new_category."')");	
			if($insertCat){
				$catId = mysqli_insert_id($con);	
				$insertQry = "INSERT INTO tbl_project_expense(project_id, cat_id, amount, date, description, added_by) VALUES (
				'".$projectId."',
				'".$catId."',
				 '".mysqli_real_escape_string($con, $amount)."',
				 '".$expDate."',
				 '".mysqli_real_escape_string($con, $description)."',
				 '".mysqli_real_escape_string($con, $_SESSION['adminId'])."')";
			} else {
				$error = 'Unable to save new category';
			}
		}
		
		$execInsert = mysqli_query($con,$insertQry);		
		if($execInsert) {
						
			$success = 'Expense Added Successfully';
			header('Location:index.php?page=project_expenses&id='.$projectId.'&success='.$success);
			exit();			
		}				
	} 
}

if(isset($_POST['update'])) {
		
	$new_category = '';
	$category = '';	
	
	if(strlen(trim($_POST['description'])) > 0) {
		$description = trim($_POST['description']);
	} else {
		$description = '';
	}	
		
	if(strlen(trim($_POST['amount'])) > 0) {
		$amount = trim($_POST['amount']);
		if(is_numeric($amount) && $amount>0){
			//ok
		} else {
			$error = 'Please enter a valid amount';
		}
	} else {
		$error = 'Please enter amount';
	}
	
	if(isset($_POST['exp_date']) && strlen($_POST['exp_date'])>0) {
		$expDate = trim($_POST['exp_date']);
	} else {
		$error = 'Please select Date';
	}
	
	if(strlen(trim($_POST['category'])) > 0) {
		$category = trim($_POST['category']);
	} else {
		$error = 'Please select category';		
	}
	
		
	if(empty($error)) {
		$curDate = date('Y-m-d H:i:s');			
				
		
			$insertQry = "UPDATE tbl_project_expense SET cat_id = '".$category."', amount = '".mysqli_real_escape_string($con, $amount)."', 
			description = '".mysqli_real_escape_string($con, $description)."',
			date = '".$expDate."', 
			updated_by = '".mysqli_real_escape_string($con, $_SESSION['adminId'])."', 
			updated_on = '".$curDate."' WHERE id = '".$editId."'";
		
		
		$execInsert = mysqli_query($con,$insertQry);		
		if($execInsert) {
						
			$success = 'Expense Updated Successfully';
			header('Location:index.php?page=project_expenses&id='.$projectId.'&success='.$success);
			exit();			
		}				
	} 
}



?>