<?php
/*
* date last modified 03-10-2017
* Edited by PI-Digi Logical Solutions
* HTML Files - manage_staff.html.php
* Mysql Tables - tbl_admin, tbl_purchase_partner, tbl_admin_type
*/
require_once('./classes/class.noseo_pagination.php'); # pagination class
require_once('./includes/functions.php'); # general functions

if(isset($_REQUEST['p']) && $_REQUEST['p']!=''){
	$p = trim($_REQUEST['p']);
} else {
	$p = 1;
}

//get details from settings
$settingsRec = mysqli_fetch_array(mysqli_query($con, "SELECT referrer_commission, referrer_commission_amount, referee_commission, referee_commission_amount FROM tbl_settings WHERE id = '1'"));
$refCommission = $settingsRec['referrer_commission'];
$refCommissionAmount = $settingsRec['referrer_commission_amount'];
$refereeCommission = $settingsRec['referee_commission'];
$refereeCommissionAmount = $settingsRec['referee_commission_amount'];

$pageVars = '';
$showAssign = FALSE;

// Get All User details to list 
$where = '';

if(isset($_POST['clear'])) { ?>
<script language="javascript" type="text/javascript">			
	window.location='index.php?page=<?php echo $page;?>';
</script>
<?php }
//print_r($_POST);
if(isset($_REQUEST['searchvalue']) && strlen($_REQUEST['searchvalue'])>0) {
	$keyword = trim($_REQUEST['searchvalue']);
	$where.= " AND name LIKE '%".$keyword."%' ";
	$pageVars.= '&searchvalue='.$keyword;
}

if(isset($_REQUEST['date_to']) && strlen($_REQUEST['date_to'])>0) {
	$to_date = trim($_REQUEST['date_to']);
	if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$to_date)) {
		//ok - yyy-mm-dd
	} else {
	    $dateArr = explode('-', $to_date);
		$to_date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
	}
} else {
	$to_date = '';
}

if(isset($_REQUEST['from_date']) && strlen($_REQUEST['from_date'])>0) {
	$from_date = trim($_REQUEST['from_date']);
	if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$from_date)) {
	    //ok - yyy-mm-dd
	} else {
	    $dateArr = explode('-', $from_date);
		$from_date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
	}
} else {
	$from_date = '';
}
$curDate = date('Y-m-d');

if($from_date!='' && $to_date!=''){
	$where .= " AND date(date) BETWEEN '".$from_date."' AND '".$to_date."' ";	
	$pageVars.= '&from_date='.$_REQUEST['from_date'].'&date_to='.$_REQUEST['date_to'].'&';
} else if($from_date!=''){	
	$where .= " AND date(date) BETWEEN '".$from_date."' AND '".$curDate."' ";	
	$pageVars.= '&from_date='.$_REQUEST['from_date'].'&';
} else if($to_date!=''){	
	$where .= " AND date(date) BETWEEN '".$to_date."' AND '".$curDate."' ";	
	$pageVars.= '&date_to='.$_REQUEST['date_to'].'&';
} 

$orderBy="";
if(isset($_REQUEST['order']) && $_REQUEST['order']=='name_asc'){
	$orderBy = " ORDER BY name ASC ";
	$pageVars .=  "&order=name_asc&"; 
} else if(isset($_REQUEST['order']) && $_REQUEST['order']=='name_dsc'){
	$orderBy = " ORDER BY name DESC ";
	$pageVars .=  "&order=name_dsc&"; 
}

//$select = "SELECT id, name, email FROM `tbl_user` WHERE `id` IN (SELECT DISTINCT `ref_id` FROM tbl_user) ORDER BY id";
$select = "SELECT * FROM `tbl_user` WHERE ref_id > 0 AND `status`!='Deleted'".$where.$orderBy;

//echo $select;
// Using pagination class
$pagination = new pagination_noseo($select);
$execDetails = $pagination->createPages(30, $con);

$pageLnk = 'index.php?page='.$page.'&'.$pageVars;
$pageNums = $pagination->pageNumber(5, $pageLnk);

if(isset($_POST['export'])) {
	include '../export/DBController.php';
	$db_handle = new DBController();	
	$selectExport = "SELECT * FROM `tbl_user` WHERE ref_id > 0".$where.$orderBy;
	$productResult = $db_handle->runQuery($selectExport);
	
    $filename = "ODP-Referral-".time().".xls";
    header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"$filename\"");
    $isPrintHeader = false;
	$label = array('0'=>'SNo.','1'=>'Customer','2'=>'Referee Name','3'=>'Referral Commission','4'=>'Referee Commission','5'=>'Used Amount','6'=>'Balance');
    if (! empty($productResult)) {
    	$slNo = 1;
        foreach ($productResult as $row) {
        	//$colCount = 0;
            if (! $isPrintHeader) {
                //echo implode("\t", array_keys($row)) . "\n";
				echo implode("\t", $label) . "\n";
                $isPrintHeader = true;				
            }
			if($row['ref_id']>0){
				$refereeCommission = $refereeCommissionAmount;
			} else {
				$refereeCommission = 0;
			}
			$refereeCommission =  number_format((float)$refereeCommission, 2, '.', '');
			$refCommission =  number_format((float)$refCommissionAmount, 2, '.', '');
			$res_referee = mysqli_fetch_array(mysqli_query($con, 'SELECT name FROM `tbl_user` WHERE id='.$row['ref_id']));
			
			$res_used = mysqli_fetch_array(mysqli_query($con, 'SELECT SUM(wallet_amount) AS amount FROM `tbl_technician_payments` WHERE user_id='.$row['id']));
			if($res_used['amount']!='') {
				$used_amount = $res_used['amount'];
			} else {
				$used_amount = '0.00';
			}
			$res_total = mysqli_fetch_array(mysqli_query($con, 'SELECT SUM(amount) total FROM `tbl_user_payments` WHERE user_id='.$row['id']));
			if($res_total['total']!='') {
				$total = $res_total['total'];
			} else {
				$total = 0;
			}
			$balance = $total-$used_amount;
			
			echo $slNo."\t";
			echo $row['name']."\t";
			echo $res_referee['name']."\t";
			echo $refCommission."\t";
			echo $refereeCommission."\t";
			echo $used_amount."\t";
			echo $balance."\t";
			echo "\n";
			$slNo++;
        }
    }
    exit();
}
?>